/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class Type1C
extends Type1 {
    static final boolean debugFont = false;
    static final boolean debugDictionary = false;
    int ROS = -1;
    int CIDFontVersion = 0;
    int CIDFontRevision = 0;
    int CIDFontType = 0;
    int CIDcount = 0;
    int UIDBase = -1;
    int FDArray = -1;
    int FDSelect = -1;
    static final String[] OneByteCCFDict = new String[]{"version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "Escape", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "shortint", "longint", "BCD", "-reserved-"};
    static final String[] TwoByteCCFDict = new String[]{"Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", "-reserved-", "-reserved-", "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"};
    private int top = 0;
    private int charset = 0;
    private int enc = 0;
    private int charstrings = 0;
    private int stringIdx;
    private int stringStart;
    private int stringOffSize;
    private Rectangle BBox = null;
    private boolean hasFontMatrix = false;
    private int privateDict = -1;
    private int privateDictOffset = -1;
    private int defaultWidthX = 0;
    private int nominalWidthX = 0;
    private static final int[] ExpertSubCharset = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    public static final String[] type1CStdStrings = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    private static final int[] ISOAdobeCharset = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228};
    private static final int[] ExpertCharset = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};

    public Type1C() {
    }

    public Type1C(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new T1Glyphs(false);
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    protected void readEmbeddedFont(PdfObject pdfObject) throws Exception {
        if (this.substituteFont != null) {
            block23: {
                byte[] byArray;
                Object object;
                InputStream inputStream;
                ByteArrayOutputStream byteArrayOutputStream;
                block22: {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    inputStream = null;
                    try {
                        inputStream = this.substituteFont.startsWith("jar:") || this.substituteFont.startsWith("http:") ? this.loader.getResourceAsStream(this.substituteFont) : this.loader.getResourceAsStream("file:///" + this.substituteFont);
                    }
                    catch (Exception exception) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("3.Unable to open " + this.substituteFont);
                        }
                    }
                    catch (Error error) {
                        if (!LogWriter.isOutput()) break block22;
                        LogWriter.writeLog("3.Unable to open " + this.substituteFont);
                    }
                }
                if (inputStream == null) {
                    int n;
                    int n2;
                    object = new File(this.substituteFont);
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    long l = ((File)object).length();
                    if (l > Integer.MAX_VALUE) {
                        System.out.println("Sorry! Your given file is too large.");
                        return;
                    }
                    byArray = new byte[(int)l];
                    for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
                    }
                    if (n < byArray.length) {
                        throw new IOException("Could not completely read file " + ((File)object).getName());
                    }
                    ((InputStream)fileInputStream).close();
                } else {
                    int n;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    object = new byte[65535];
                    while ((n = bufferedInputStream.read((byte[])object)) != -1) {
                        byteArrayOutputStream.write((byte[])object, 0, n);
                    }
                    byteArrayOutputStream.close();
                    bufferedInputStream.close();
                    byArray = byteArrayOutputStream.toByteArray();
                }
                try {
                    this.isFontSubstituted = true;
                    this.readType1FontFile(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block23;
                    LogWriter.writeLog("[PDF]Substitute font=" + this.substituteFont + "Type 1 exception=" + exception);
                }
            }
            if (this.isFontSubstituted && this.glyphs.remapFont) {
                this.glyphs.remapFont = false;
            }
        } else if (pdfObject != null) {
            PdfObject pdfObject2 = pdfObject.getDictionary(746093177);
            if (pdfObject2 != null) {
                try {
                    byte[] byArray = this.currentPdfFile.readStream(pdfObject2, true, true, false, false, false, pdfObject2.getCacheName(this.currentPdfFile.getObjectReader()));
                    if (byArray != null) {
                        this.readType1FontFile(byArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                byte[] byArray;
                PdfObject pdfObject3 = pdfObject.getDictionary(2021292335);
                if (pdfObject3 != null && (byArray = this.currentPdfFile.readStream(pdfObject3, true, true, false, false, false, pdfObject3.getCacheName(this.currentPdfFile.getObjectReader()))) != null && (byArray.length <= 3 || byArray[0] != 719 || byArray[1] != 84 || byArray[2] != 84 || byArray[3] != 79)) {
                    this.readType1CFontFile(byArray, null);
                }
            }
        }
    }

    public void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        this.fontTypes = 1228944677;
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject2);
        this.setName(pdfObject, string);
        this.setEncoding(pdfObject, pdfObject2);
        try {
            this.readEmbeddedFont(pdfObject2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.readWidths(pdfObject, true);
        if (bl) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    public Type1C(byte[] byArray, PdfJavaGlyphs pdfJavaGlyphs, boolean bl) throws Exception {
        this.glyphs = pdfJavaGlyphs;
        this.trackIndices = true;
        this.renderPage = true;
        if (bl) {
            this.readType1CFontFile(byArray, null);
        } else {
            this.readType1FontFile(byArray);
        }
    }

    public Type1C(byte[] byArray, FontData fontData, PdfJavaGlyphs pdfJavaGlyphs) throws Exception {
        this.glyphs = pdfJavaGlyphs;
        this.readType1CFontFile(byArray, fontData);
    }

    private final void readType1CFontFile(byte[] byArray, FontData fontData) throws Exception {
        int n;
        int n2;
        int n3;
        byte by;
        int n4;
        byte by2;
        byte by3;
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Embedded Type1C font used");
        }
        this.glyphs.setis1C(true);
        boolean bl = byArray != null;
        int n5 = 2;
        if (bl) {
            by3 = byArray[0];
            by2 = byArray[1];
        } else {
            by3 = fontData.getByte(0);
            by2 = fontData.getByte(1);
        }
        if ((by3 != 1 || by2 != 0) && LogWriter.isOutput()) {
            LogWriter.writeLog("1C  format " + by3 + ':' + by2 + " not fully supported");
        }
        this.top = bl ? byArray[2] : (int)fontData.getByte(2);
        if (bl) {
            n4 = Type1C.getWord(byArray, this.top, n5);
            by = byArray[this.top + n5];
        } else {
            n4 = Type1C.getWord(fontData, this.top, n5);
            by = fontData.getByte(this.top + n5);
        }
        this.top += n5 + 1;
        int n6 = this.top + (n4 + 1) * by - 1;
        this.top = bl ? n6 + Type1C.getWord(byArray, this.top + n4 * by, (int)by) : n6 + Type1C.getWord(fontData, this.top + n4 * by, (int)by);
        if (bl) {
            n4 = Type1C.getWord(byArray, this.top, n5);
            by = byArray[this.top + n5];
        } else {
            n4 = Type1C.getWord(fontData, this.top, n5);
            by = fontData.getByte(this.top + n5);
        }
        this.top += n5 + 1;
        n6 = this.top + (n4 + 1) * by - 1;
        if (bl) {
            n3 = n6 + Type1C.getWord(byArray, this.top, (int)by);
            n2 = n6 + Type1C.getWord(byArray, this.top + by, (int)by);
        } else {
            n3 = n6 + Type1C.getWord(fontData, this.top, (int)by);
            n2 = n6 + Type1C.getWord(fontData, this.top + by, (int)by);
        }
        String[] stringArray = this.readStringIndex(byArray, fontData, n6, by, n4);
        this.readGlobalSubRoutines(byArray, fontData);
        this.decodeDictionary(byArray, fontData, n3, n2, stringArray);
        if (this.FDSelect != -1) {
            n = this.FDArray;
            if (bl) {
                n4 = Type1C.getWord(byArray, n, n5);
                by = byArray[n + n5];
            } else {
                n4 = Type1C.getWord(fontData, n, n5);
                by = fontData.getByte(n + n5);
            }
            n6 = (n += n5 + 1) + (n4 + 1) * by - 1;
            if (bl) {
                n3 = n6 + Type1C.getWord(byArray, n, (int)by);
                n2 = n6 + Type1C.getWord(byArray, n + by, (int)by);
            } else {
                n3 = n6 + Type1C.getWord(fontData, n, (int)by);
                n2 = n6 + Type1C.getWord(fontData, n + by, (int)by);
            }
            this.decodeDictionary(byArray, fontData, n3, n2, stringArray);
        }
        this.top = this.charstrings;
        n = bl ? Type1C.getWord(byArray, this.top, n5) : Type1C.getWord(fontData, this.top, n5);
        this.glyphs.setGlyphCount(n);
        int[] nArray = Type1C.readCharset(this.charset, n, this.charstrings, fontData, byArray);
        this.setEncoding(byArray, fontData, n, nArray);
        this.top = this.charstrings;
        this.readGlyphs(byArray, fontData, n, nArray);
        if (this.privateDict != -1) {
            int n7;
            this.decodeDictionary(byArray, fontData, this.privateDict, this.privateDictOffset + this.privateDict, stringArray);
            this.top = this.privateDict + this.privateDictOffset;
            int n8 = bl ? byArray.length : fontData.length();
            if (this.top + 2 < n8 && (n7 = bl ? Type1C.getWord(byArray, this.top, n5) : Type1C.getWord(fontData, this.top, n5)) > 0) {
                this.readSubrs(byArray, fontData, n7);
            }
        }
        this.isFontEmbedded = true;
        this.glyphs.setFontEmbedded(true);
    }

    private final void setEncoding(byte[] byArray, FontData fontData, int n, int[] nArray) {
        boolean bl;
        boolean bl2 = bl = byArray != null;
        if (this.enc == 0) {
            this.embeddedEnc = 1;
            if (this.fontEnc == -1) {
                this.putFontEncoding(1);
            }
            if (this.isCID) {
                try {
                    for (int i = 1; i < n; ++i) {
                        if (nArray[i] >= 391) continue;
                        String string = bl ? Type1C.getString(byArray, nArray[i], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, nArray[i], this.stringIdx, this.stringStart, this.stringOffSize);
                        this.putMappedChar(nArray[i], StandardFonts.getUnicodeName(string));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (this.enc == 1) {
            this.embeddedEnc = 3;
            if (this.fontEnc == -1) {
                this.putFontEncoding(3);
            }
        } else {
            int n2;
            String string;
            int n3;
            int n4;
            int n5;
            this.top = this.enc;
            int n6 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
            if ((n6 & 0x7F) == 0) {
                n5 = bl ? 1 + (byArray[this.top++] & 0xFF) : 1 + (fontData.getByte(this.top++) & 0xFF);
                if (n5 > n) {
                    n5 = n;
                }
                for (n4 = 1; n4 < n5; ++n4) {
                    if (bl) {
                        n3 = byArray[this.top++] & 0xFF;
                        string = Type1C.getString(byArray, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                    } else {
                        n3 = fontData.getByte(this.top++) & 0xFF;
                        string = Type1C.getString(fontData, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                    }
                    this.putChar(n3, string);
                }
            } else if ((n6 & 0x7F) == 1) {
                n5 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
                n4 = 1;
                for (n2 = 0; n2 < n5; ++n2) {
                    int n7;
                    if (bl) {
                        n3 = byArray[this.top++] & 0xFF;
                        n7 = byArray[this.top++] & 0xFF;
                    } else {
                        n3 = fontData.getByte(this.top++) & 0xFF;
                        n7 = fontData.getByte(this.top++) & 0xFF;
                    }
                    for (int i = 0; i <= n7 && n4 < n; ++i) {
                        string = bl ? Type1C.getString(byArray, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                        this.putChar(n3, string);
                        ++n4;
                        ++n3;
                    }
                }
            }
            if ((n6 & 0x80) != 0) {
                n5 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
                    n2 = bl ? Type1C.getWord(byArray, this.top, 2) : Type1C.getWord(fontData, this.top, 2);
                    this.top += 2;
                    string = bl ? Type1C.getString(byArray, n2, this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, n2, this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putChar(n3, string);
                }
            }
        }
    }

    private final void readSubrs(byte[] byArray, FontData fontData, int n) throws Exception {
        int n2;
        boolean bl = byArray != null;
        byte by = bl ? byArray[this.top + 2] : fontData.getByte(this.top + 2);
        this.top += 3;
        int n3 = this.top;
        int n4 = this.top + (n + 1) * by - 1;
        int n5 = this.top + n * by;
        this.top = bl ? (n5 < byArray.length ? n4 + Type1C.getWord(byArray, n5, (int)by) : byArray.length - 1) : (n5 < byArray.length ? n4 + Type1C.getWord(fontData, n5, (int)by) : fontData.length() - 1);
        int[] nArray = new int[n + 2];
        int n6 = n3;
        for (n2 = 0; n2 < n + 1; ++n2) {
            if (bl) {
                if (n6 + by < byArray.length) {
                    nArray[n2] = n4 + Type1C.getWord(byArray, n6, (int)by);
                }
            } else if (n6 + by < fontData.length()) {
                nArray[n2] = n4 + Type1C.getWord(fontData, n6, (int)by);
            }
            n6 += by;
        }
        nArray[n + 1] = this.top;
        this.glyphs.setLocalBias(Type1C.calculateSubroutineBias(n));
        n2 = nArray[0];
        for (int i = 1; i < n + 1; ++i) {
            int n7;
            if (n2 == 0 || nArray[i] > byArray.length || nArray[i] < 0 || nArray[i] == 0) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (n7 = n2; n7 < nArray[i]; ++n7) {
                if (bl || n7 >= fontData.length()) continue;
                byteArrayOutputStream.write(fontData.getByte(n7));
            }
            if (bl) {
                n7 = nArray[i] - n2;
                if (n7 > 0) {
                    byte[] byArray2 = new byte[n7];
                    System.arraycopy(byArray, n2, byArray2, 0, n7);
                    this.glyphs.setCharString("subrs" + (i - 1), byArray2);
                }
            } else {
                byteArrayOutputStream.close();
                this.glyphs.setCharString("subrs" + (i - 1), byteArrayOutputStream.toByteArray());
            }
            n2 = nArray[i];
        }
    }

    private final void readGlyphs(byte[] byArray, FontData fontData, int n, int[] nArray) throws Exception {
        int n2;
        boolean bl = byArray != null;
        byte by = bl ? byArray[this.top + 2] : fontData.getByte(this.top + 2);
        this.top += 3;
        int n3 = this.top;
        int n4 = this.top + (n + 1) * by - 1;
        this.top = bl ? n4 + Type1C.getWord(byArray, this.top + n * by, (int)by) : n4 + Type1C.getWord(fontData, this.top + n * by, (int)by);
        int[] nArray2 = new int[n + 2];
        int n5 = n3;
        for (n2 = 0; n2 < n + 1; ++n2) {
            nArray2[n2] = bl ? n4 + Type1C.getWord(byArray, n5, (int)by) : n4 + Type1C.getWord(fontData, n5, (int)by);
            n5 += by;
        }
        nArray2[n + 1] = this.top;
        n2 = nArray2[0];
        for (int i = 1; i < n + 1; ++i) {
            byte[] byArray2 = new byte[nArray2[i] - n2];
            for (int j = n2; j < nArray2[i]; ++j) {
                byArray2[j - n2] = bl ? byArray[j] : fontData.getByte(j);
            }
            String string = this.isCID ? String.valueOf(nArray[i - 1]) : (bl ? Type1C.getString(byArray, nArray[i - 1], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, nArray[i - 1], this.stringIdx, this.stringStart, this.stringOffSize));
            this.glyphs.setCharString(string, byArray2);
            n2 = nArray2[i];
            if (!this.trackIndices) continue;
            this.glyphs.setIndexForCharString(i, string);
        }
    }

    private static final int calculateSubroutineBias(int n) {
        int n2 = n < 1240 ? 107 : (n < 33900 ? 1131 : 32768);
        return n2;
    }

    private final void readGlobalSubRoutines(byte[] byArray, FontData fontData) throws Exception {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = byArray != null;
        if (bl) {
            n2 = byArray[this.top + 2] & 0xFF;
            n = Type1C.getWord(byArray, this.top, 2);
        } else {
            n2 = fontData.getByte(this.top + 2) & 0xFF;
            n = Type1C.getWord(fontData, this.top, 2);
        }
        this.top += 3;
        if (n > 0) {
            int n3;
            int n4 = this.top;
            int n5 = this.top + (n + 1) * n2 - 1;
            this.top = bl ? n5 + Type1C.getWord(byArray, this.top + n * n2, n2) : n5 + Type1C.getWord(fontData, this.top + n * n2, n2);
            int[] nArray = new int[n + 2];
            int n6 = n4;
            for (n3 = 0; n3 < n + 1; ++n3) {
                nArray[n3] = bl ? n5 + Type1C.getWord(byArray, n6, n2) : n5 + Type1C.getWord(fontData, n6, n2);
                n6 += n2;
            }
            nArray[n + 1] = this.top;
            this.glyphs.setGlobalBias(Type1C.calculateSubroutineBias(n));
            n3 = nArray[0];
            for (int i = 1; i < n + 1; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int j = n3; j < nArray[i]; ++j) {
                    if (bl) {
                        byteArrayOutputStream.write(byArray[j]);
                        continue;
                    }
                    byteArrayOutputStream.write(fontData.getByte(j));
                }
                byteArrayOutputStream.close();
                this.glyphs.setCharString("global" + (i - 1), byteArrayOutputStream.toByteArray());
                n3 = nArray[i];
            }
        }
    }

    private void decodeDictionary(byte[] byArray, FontData fontData, int n, int n2, String[] stringArray) {
        boolean bl = false;
        boolean bl2 = byArray != null;
        int n3 = n;
        int n4 = 0;
        double[] dArray = new double[48];
        while (n3 < n2) {
            int n5 = bl2 ? byArray[n3] & 0xFF : fontData.getByte(n3) & 0xFF;
            if (n5 <= 27 || n5 == 31) {
                int n6;
                int n7 = n5;
                ++n3;
                if (n7 == 12) {
                    n7 = bl2 ? byArray[n3] & 0xFF : fontData.getByte(n3) & 0xFF;
                    ++n3;
                    if (n7 == 36 || n7 == 37 || n7 == 7 || this.FDSelect == -1) {
                        if (n7 == 2) {
                            this.italicAngle = (int)dArray[0];
                        } else if (n7 == 7) {
                            if (!this.hasFontMatrix) {
                                System.arraycopy(dArray, 0, this.FontMatrix, 0, 6);
                            }
                            this.hasFontMatrix = true;
                        } else if (n7 == 30) {
                            this.ROS = (int)dArray[0];
                            this.isCID = true;
                        } else if (n7 == 31) {
                            this.CIDFontVersion = (int)dArray[0];
                        } else if (n7 == 32) {
                            this.CIDFontRevision = (int)dArray[0];
                        } else if (n7 == 33) {
                            this.CIDFontType = (int)dArray[0];
                        } else if (n7 == 34) {
                            this.CIDcount = (int)dArray[0];
                        } else if (n7 == 35) {
                            this.UIDBase = (int)dArray[0];
                        } else if (n7 == 36) {
                            this.FDArray = (int)dArray[0];
                        } else if (n7 == 37) {
                            this.FDSelect = (int)dArray[0];
                            bl = true;
                        } else if (n7 == 0) {
                            n6 = (int)dArray[0];
                            if (n6 > 390) {
                                n6 -= 390;
                            }
                            this.copyright = stringArray[n6];
                        } else if (n7 != 21 && n7 != 22 && n7 == 38) {
                            // empty if block
                        }
                    }
                } else if (n7 == 2) {
                    n6 = (int)dArray[0];
                    if (n6 > 390) {
                        n6 -= 390;
                    }
                    this.embeddedFontName = stringArray[n6];
                } else if (n7 != 3) {
                    if (n7 == 5) {
                        for (n6 = 0; n6 < 4; ++n6) {
                            this.FontBBox[n6] = (float)dArray[n6];
                        }
                    } else if (n7 == 15) {
                        this.charset = (int)dArray[0];
                    } else if (n7 == 16) {
                        this.enc = (int)dArray[0];
                    } else if (n7 == 17) {
                        this.charstrings = (int)dArray[0];
                    } else if (n7 == 18 && this.glyphs.is1C()) {
                        this.privateDict = (int)dArray[1];
                        this.privateDictOffset = (int)dArray[0];
                    } else if (n7 == 20) {
                        this.defaultWidthX = (int)dArray[0];
                        if (this.glyphs instanceof T1Glyphs) {
                            ((T1Glyphs)this.glyphs).setWidthValues(this.defaultWidthX, this.nominalWidthX);
                        }
                    } else if (n7 == 21) {
                        this.nominalWidthX = (int)dArray[0];
                        if (this.glyphs instanceof T1Glyphs) {
                            ((T1Glyphs)this.glyphs).setWidthValues(this.defaultWidthX, this.nominalWidthX);
                        }
                    }
                }
                n4 = 0;
                continue;
            }
            n3 = bl2 ? this.glyphs.getNumber(byArray, n3, dArray, n4, false) : this.glyphs.getNumber(fontData, n3, dArray, n4, false);
            ++n4;
        }
        if (!bl) {
            this.FDSelect = -1;
        }
    }

    private String[] readStringIndex(byte[] byArray, FontData fontData, int n, int n2, int n3) {
        int n4;
        int n5;
        boolean bl;
        boolean bl2 = bl = byArray != null;
        if (bl) {
            this.top = n + Type1C.getWord(byArray, this.top + n3 * n2, n2);
            n5 = Type1C.getWord(byArray, this.top, 2);
            this.stringOffSize = byArray[this.top + 2];
        } else {
            this.top = n + Type1C.getWord(fontData, this.top + n3 * n2, n2);
            n5 = Type1C.getWord(fontData, this.top, 2);
            this.stringOffSize = fontData.getByte(this.top + 2);
        }
        this.top += 3;
        this.stringIdx = this.top;
        this.stringStart = this.top + (n5 + 1) * this.stringOffSize - 1;
        this.top = bl ? this.stringStart + Type1C.getWord(byArray, this.top + n5 * this.stringOffSize, this.stringOffSize) : this.stringStart + Type1C.getWord(fontData, this.top + n5 * this.stringOffSize, this.stringOffSize);
        int[] nArray = new int[n5 + 2];
        String[] stringArray = new String[n5 + 2];
        int n6 = this.stringIdx;
        for (n4 = 0; n4 < n5 + 1; ++n4) {
            nArray[n4] = bl ? Type1C.getWord(byArray, n6, this.stringOffSize) : Type1C.getWord(fontData, n6, this.stringOffSize);
            n6 += this.stringOffSize;
        }
        nArray[n5 + 1] = this.top - this.stringStart;
        n4 = 0;
        for (int i = 0; i < n5 + 1; ++i) {
            StringBuffer stringBuffer = new StringBuffer(nArray[i] - n4);
            for (int j = n4; j < nArray[i]; ++j) {
                if (bl) {
                    stringBuffer.append((char)byArray[this.stringStart + j]);
                    continue;
                }
                stringBuffer.append((char)fontData.getByte(this.stringStart + j));
            }
            stringArray[i] = stringBuffer.toString();
            n4 = nArray[i];
        }
        return stringArray;
    }

    private static final String getString(FontData fontData, int n, int n2, int n3, int n4) {
        String string;
        if (n < 391) {
            string = type1CStdStrings[n];
        } else {
            int n5 = n3 + Type1C.getWord(fontData, n2 + (n -= 391) * n4, n4);
            int n6 = n3 + Type1C.getWord(fontData, n2 + (n + 1) * n4, n4);
            int n7 = n6 - n5;
            if (n7 > 255) {
                n7 = 255;
            }
            string = new String(fontData.getBytes(n5, n7));
        }
        return string;
    }

    private static final String getString(byte[] byArray, int n, int n2, int n3, int n4) {
        String string;
        if (n < 391) {
            string = type1CStdStrings[n];
        } else {
            int n5 = n3 + Type1C.getWord(byArray, n2 + (n -= 391) * n4, n4);
            int n6 = n3 + Type1C.getWord(byArray, n2 + (n + 1) * n4, n4);
            int n7 = n6 - n5;
            if (n7 > 255) {
                n7 = 255;
            }
            string = new String(byArray, n5, n7);
        }
        return string;
    }

    private static final int[] readCharset(int n, int n2, int n3, FontData fontData, byte[] byArray) {
        int[] nArray;
        block6: {
            int n4;
            boolean bl;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                boolean bl2 = bl = byArray != null;
                                if (n != 0) break block5;
                                nArray = ISOAdobeCharset;
                                break block6;
                            }
                            if (n != 1) break block7;
                            nArray = ExpertCharset;
                            break block6;
                        }
                        if (n != 2) break block8;
                        nArray = ExpertSubCharset;
                        break block6;
                    }
                    nArray = new int[n2 + 1];
                    nArray[0] = 0;
                    n3 = n;
                    n4 = bl ? byArray[n3++] & 0xFF : fontData.getByte(n3++) & 0xFF;
                    if (n4 != 0) break block9;
                    for (int i = 1; i < n2; ++i) {
                        nArray[i] = bl ? Type1C.getWord(byArray, n3, 2) : Type1C.getWord(fontData, n3, 2);
                        n3 += 2;
                    }
                    break block6;
                }
                if (n4 != 1) break block10;
                int n5 = 1;
                while (n5 < n2) {
                    int n6 = bl ? Type1C.getWord(byArray, n3, 2) : Type1C.getWord(fontData, n3, 2);
                    n3 += 2;
                    int n7 = bl ? byArray[n3++] & 0xFF : fontData.getByte(n3++) & 0xFF;
                    for (int i = 0; i <= n7; ++i) {
                        nArray[n5++] = n6++;
                    }
                }
                break block6;
            }
            if (n4 != 2) break block6;
            int n8 = 1;
            while (n8 < n2) {
                int n9 = bl ? Type1C.getWord(byArray, n3, 2) : Type1C.getWord(fontData, n3, 2);
                int n10 = bl ? Type1C.getWord(byArray, n3, 2) : Type1C.getWord(fontData, n3 += 2, 2);
                n3 += 2;
                for (int i = 0; i <= n10; ++i) {
                    nArray[n8++] = n9++;
                }
            }
        }
        return nArray;
    }

    private static final int getWord(FontData fontData, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (fontData.getByte(n + i) & 0xFF);
        }
        return n3;
    }

    private static final int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }

    public Rectangle getBoundingBox() {
        if (this.BBox == null) {
            this.BBox = this.isFontEmbedded ? new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1])) : super.getBoundingBox();
        }
        return this.BBox;
    }
}

