/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.wiki;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.debux.webmotion.server.WebMotionController;
import org.debux.webmotion.server.call.UploadFile;
import org.debux.webmotion.server.render.Render;
import org.debux.webmotion.wiki.service.WikiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Media
extends WebMotionController {
    private static final Logger log = LoggerFactory.getLogger(Media.class);
    protected WikiService service;

    public Media() {
        this(new WikiService());
    }

    public Media(WikiService service) {
        this.service = service;
    }

    public Render get(String nameSpace, String mediaName) throws Exception {
        File file = this.service.getMedia(nameSpace, mediaName);
        if (file.exists()) {
            return this.renderStream((InputStream)new FileInputStream(file), null);
        }
        return null;
    }

    public Render attach(String nameSpace) throws Exception {
        String url = "/media";
        if (nameSpace != null) {
            url = url + "/" + nameSpace;
        }
        return this.renderView("media/attach.jsp", new Object[]{"url", url});
    }

    public Render upload(String nameSpace, UploadFile file) throws Exception {
        String name = file.getName();
        File content = file.getFile();
        this.service.uploadMedia(nameSpace, name, content);
        if (nameSpace == null) {
            return this.renderURL("/media", new Object[]{"name", name});
        }
        return this.renderURL("/media/" + nameSpace, new Object[]{"name", name});
    }

    public Render map(String nameSpace) throws Exception {
        String url = "/media";
        if (nameSpace != null) {
            url = url + "/" + nameSpace;
        }
        Map map = this.service.getMediaMap(nameSpace);
        return this.renderView("media/map.jsp", new Object[]{"map", map, "url", url});
    }
}

