/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.chorem.vradi.VradiServiceConfiguration;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfigOption;

public class VradiServiceConfigurationHelper {
    public static String getApplicationVersion(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.APPLICATION_VERSION.key);
    }

    public static String getServiceVersion(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.SERVICE_VERSION.key);
    }

    public static void setServiceVersion(ApplicationConfig config, String version) {
        config.setOption(VradiServiceConfiguration.VradiServiceOption.SERVICE_VERSION.key, version);
    }

    public static String getDataDir(ApplicationConfig config) {
        String option = config.getOption(VradiServiceConfiguration.VradiServiceOption.DATA_DIR.key);
        return option;
    }

    public static File getDataDirAsFile(ApplicationConfig config) {
        File option = config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.DATA_DIR.key);
        return option;
    }

    public static Locale getLocale(ApplicationConfig config) {
        Locale result = (Locale)config.getOption(Locale.class, VradiServiceConfiguration.VradiServiceOption.LOCALE.key);
        return result;
    }

    public static void setLocale(ApplicationConfig config, Locale locale) {
        config.setOption(VradiServiceConfiguration.VradiServiceOption.LOCALE.key, locale.toString());
    }

    public static File getAttachmentsDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.ATTACHEMENTS_DIR.key);
    }

    public static File getSessionAttachmentsDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.SESSION_ATTACHEMENTS_DIR.key);
    }

    public static File getEmbeddedFilesDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.EMBEDDED_DIR.key);
    }

    public static File getQueryHistoryDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.QUERY_HISTORY_DIR.key);
    }

    public static File getTemplatesDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.TEMPLATE_DIR.key);
    }

    public static File getPdfDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.PDF_DIR.key);
    }

    public static File getTempDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.TEMP_DIR.key);
    }

    public static File getExportCSVDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.EXPORT_CSV_DIR.key);
    }

    public static File getImportCSVDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.IMPORT_CSV_DIR.key);
    }

    public static File getWebHarvestPreviewDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.WEB_HARVERT_SCRIPT_PREVIEW_DIR.key);
    }

    public static File getWebHarvestScriptDir(ApplicationConfig config) {
        return config.getOptionAsFile(VradiServiceConfiguration.VradiServiceOption.WEB_HARVERT_SCRIPT_DIR.key);
    }

    public static String getOpenOfficeExecDir(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.OOO_DIR.key);
    }

    public static String getSmtpHost(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.SMTP_HOST.key);
    }

    public static int getSmtpPort(ApplicationConfig config) {
        return config.getOptionAsInt(VradiServiceConfiguration.VradiServiceOption.SMTP_PORT.key);
    }

    public static String getImapHost(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.IMAP_HOST.key);
    }

    public static int getImapPort(ApplicationConfig config) {
        return config.getOptionAsInt(VradiServiceConfiguration.VradiServiceOption.IMAP_PORT.key);
    }

    public static String getMailUser(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.MAIL_USER.key);
    }

    public static String getMailFrom(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.MAIL_FROM.key);
    }

    public static String getMailFromName(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.MAIL_FROM_NAME.key);
    }

    public static String getMailPassword(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.MAIL_PASSWORD.key);
    }

    public static String getOfferMailSubject(ApplicationConfig config) {
        String result = config.getOption(VradiServiceConfiguration.VradiServiceOption.MAIL_OFFER_SUBJECT.key);
        return result;
    }

    public static boolean isMailDebug(ApplicationConfig config) {
        return config.getOptionAsBoolean(VradiServiceConfiguration.VradiServiceOption.MAIL_DEBUG.key);
    }

    public static List<String> getMailAdmin(ApplicationConfig config) {
        return VradiServiceConfigurationHelper.getOptionAsList(config, VradiServiceConfiguration.VradiServiceOption.MAIL_ADMIN.key);
    }

    public static void addMailAdmin(ApplicationConfig config, String email) {
        VradiServiceConfigurationHelper.addOptionAsList(config, VradiServiceConfiguration.VradiServiceOption.MAIL_ADMIN.key, email);
    }

    public static String getSessionDefaultParagraph(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.SESSION_DEFAULT_PARAGRAPH.key);
    }

    public static boolean skipMigration(ApplicationConfig config) {
        return config.getOptionAsBoolean(VradiServiceConfiguration.VradiServiceOption.SKIP_MIGRATION.key);
    }

    public static String getSendTaskHour(ApplicationConfig config) {
        return config.getOption(VradiServiceConfiguration.VradiServiceOption.AUTO_SEND_HOUR.key);
    }

    public static List<String> getOptionAsList(ApplicationConfig config, String key) {
        List<String> result = new ArrayList<String>();
        String admins = config.getOption(key);
        if (admins != null && !admins.isEmpty()) {
            if (admins.contains(", ")) {
                String[] strings = admins.split(", ");
                result = Arrays.asList(strings);
            } else {
                result.add(admins);
            }
        }
        return result;
    }

    protected static void addOptionAsList(ApplicationConfig config, String key, String value) {
        List<String> list = VradiServiceConfigurationHelper.getOptionAsList(config, key);
        list.add(value);
        String values = StringUtil.join(list, (String)", ", (boolean)false);
        config.setOption(key, values);
    }

    public static void setWikittyEventPropagate(ApplicationConfig config, boolean b) {
        config.setOption(WikittyConfigOption.WIKITTY_EVENT_PROPAGATE.key, String.valueOf(b));
    }

    public static Boolean getWikittyEventPropagate(ApplicationConfig config) {
        return config.getOptionAsBoolean(WikittyConfigOption.WIKITTY_EVENT_PROPAGATE.key);
    }

    public static String getWikittyEventTransporterXMPPServer(ApplicationConfig config) {
        return config.getOption(WikittyConfigOption.WIKITTY_EVENT_TRANSPORTER_XMPP_SERVER.key);
    }

    public static String getWikittyEventTransporterXMPPRoom(ApplicationConfig config) {
        return config.getOption(WikittyConfigOption.WIKITTY_EVENT_TRANSPORTER_XMPP_ROOM.key);
    }
}

