/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.chorem.vradi.services.search.CompareFilter;

public class RangeFilter
extends CompareFilter {
    private static final long serialVersionUID = 1L;
    protected String lowerValue = null;
    protected String upperValue = null;

    public RangeFilter(String term, String lowerValue, String upperValue) {
        super(term, lowerValue);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.lowerValue = value;
    }

    public void setLowerValue(String value) {
        this.lowerValue = value;
    }

    public String getLowerValue() {
        return this.lowerValue;
    }

    public void setUpperValue(String value) {
        this.upperValue = value;
    }

    public String getUpperValue() {
        return this.upperValue;
    }

    @Override
    public boolean isNumber() {
        return NumberUtils.isNumber((String)this.lowerValue) && NumberUtils.isNumber((String)this.upperValue);
    }

    @Override
    public boolean match(Pattern pattern) {
        Matcher lowerMatcher = pattern.matcher(this.lowerValue);
        Matcher upperMatcher = pattern.matcher(this.upperValue);
        return lowerMatcher.matches() && upperMatcher.matches();
    }

    @Override
    public String toString() {
        return String.format("%s = [%s TO %s]", this.term, this.lowerValue, this.upperValue);
    }
}

