package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class SendingAbstract extends BusinessEntityImpl implements Sending {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionSending;
    /**
     * getSentDate :
     * @return Date 
     */

    @Override
    public Date getSentDate() {
        Date value = SendingHelper.getSentDate(getWikitty());
        return value;
}

    /**
     * setSentDate :
     * @param sentDate 
     */

    @Override
    public void setSentDate(Date sentDate) {
        Date oldValue = getSentDate();
        SendingHelper.setSentDate(getWikitty(), sentDate);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_SENTDATE, oldValue, getSentDate());
}

    /**
     * getReceptionDate :
     * @return Date 
     */

    @Override
    public Date getReceptionDate() {
        Date value = SendingHelper.getReceptionDate(getWikitty());
        return value;
}

    /**
     * setReceptionDate :
     * @param receptionDate 
     */

    @Override
    public void setReceptionDate(Date receptionDate) {
        Date oldValue = getReceptionDate();
        SendingHelper.setReceptionDate(getWikitty(), receptionDate);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_RECEPTIONDATE, oldValue, getReceptionDate());
}

    /**
     * getParagraph :
     * @return String 
     */

    @Override
    public String getParagraph() {
        String value = SendingHelper.getParagraph(getWikitty());
        return value;
}

    /**
     * setParagraph :
     * @param paragraph 
     */

    @Override
    public void setParagraph(String paragraph) {
        String oldValue = getParagraph();
        SendingHelper.setParagraph(getWikitty(), paragraph);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_PARAGRAPH, oldValue, getParagraph());
}

    /**
     * getReceptionProof :
     * @return boolean 
     */

    @Override
    public boolean getReceptionProof() {
        boolean value = SendingHelper.getReceptionProof(getWikitty());
        return value;
}

    /**
     * setReceptionProof :
     * @param receptionProof 
     */

    @Override
    public void setReceptionProof(boolean receptionProof) {
        boolean oldValue = getReceptionProof();
        SendingHelper.setReceptionProof(getWikitty(), receptionProof);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_RECEPTIONPROOF, oldValue, getReceptionProof());
}

    /**
     * getStatus :
     * @return int 
     */

    @Override
    public int getStatus() {
        int value = SendingHelper.getStatus(getWikitty());
        return value;
}

    /**
     * setStatus :
     * @param status 
     */

    @Override
    public void setStatus(int status) {
        int oldValue = getStatus();
        SendingHelper.setStatus(getWikitty(), status);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_STATUS, oldValue, getStatus());
}

    /**
     * getMessageId :
     * @return String 
     */

    @Override
    public String getMessageId() {
        String value = SendingHelper.getMessageId(getWikitty());
        return value;
}

    /**
     * setMessageId :
     * @param messageId 
     */

    @Override
    public void setMessageId(String messageId) {
        String oldValue = getMessageId();
        SendingHelper.setMessageId(getWikitty(), messageId);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_MESSAGEID, oldValue, getMessageId());
}

    /**
     * getUser :
     * @return String 
     */

    @Override
    public String getUser() {
        String value = SendingHelper.getUser(getWikitty());
        return value;
}

    /**
     * setUser :
     * @param user 
     */

    @Override
    public void setUser(String user) {
        String oldValue = getUser();
        SendingHelper.setUser(getWikitty(), user);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_USER, oldValue, getUser());
}

    /**
     * getDeletedGroupForms :
     * @return Set<String> 
     */

    @Override
    public Set<String> getDeletedGroupForms() {
        Set<String> result = SendingHelper.getDeletedGroupForms(getWikitty());
        return result;
}

    /**
     * setDeletedGroupForms :
     * @param deletedGroupForms 
     */

    @Override
    public void setDeletedGroupForms(Set<String> deletedGroupForms) {
        Set<String> oldValue = getDeletedGroupForms();
        SendingHelper.setDeletedGroupForms(getWikitty(), deletedGroupForms);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDGROUPFORMS, oldValue, getDeletedGroupForms());
}

    /**
     * addAllDeletedGroupForms :
     * @param deletedGroupForms 
     */

    @Override
    public void addAllDeletedGroupForms(Set<String> deletedGroupForms) {
        Set<String> oldValue = getDeletedGroupForms();
        SendingHelper.addAllDeletedGroupForms(getWikitty(), deletedGroupForms);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDGROUPFORMS, oldValue, getDeletedGroupForms());
}

    /**
     * addDeletedGroupForms :
     * @param element 
     */

    @Override
    public void addDeletedGroupForms(String element) {
        SendingHelper.addDeletedGroupForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDGROUPFORMS, null, getDeletedGroupForms());
}

    /**
     * removeDeletedGroupForms :
     * @param element 
     */

    @Override
    public void removeDeletedGroupForms(String element) {
        SendingHelper.removeDeletedGroupForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDGROUPFORMS, null, getDeletedGroupForms());
}

    /**
     * clearDeletedGroupForms :
     */

    @Override
    public void clearDeletedGroupForms() {
        SendingHelper.clearDeletedGroupForms(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_DELETEDGROUPFORMS, null, getDeletedGroupForms());
}

    /**
     * getAddedGroupForms :
     * @return Set<String> 
     */

    @Override
    public Set<String> getAddedGroupForms() {
        Set<String> result = SendingHelper.getAddedGroupForms(getWikitty());
        return result;
}

    /**
     * setAddedGroupForms :
     * @param addedGroupForms 
     */

    @Override
    public void setAddedGroupForms(Set<String> addedGroupForms) {
        Set<String> oldValue = getAddedGroupForms();
        SendingHelper.setAddedGroupForms(getWikitty(), addedGroupForms);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_ADDEDGROUPFORMS, oldValue, getAddedGroupForms());
}

    /**
     * addAllAddedGroupForms :
     * @param addedGroupForms 
     */

    @Override
    public void addAllAddedGroupForms(Set<String> addedGroupForms) {
        Set<String> oldValue = getAddedGroupForms();
        SendingHelper.addAllAddedGroupForms(getWikitty(), addedGroupForms);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_ADDEDGROUPFORMS, oldValue, getAddedGroupForms());
}

    /**
     * addAddedGroupForms :
     * @param element 
     */

    @Override
    public void addAddedGroupForms(String element) {
        SendingHelper.addAddedGroupForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_ADDEDGROUPFORMS, null, getAddedGroupForms());
}

    /**
     * removeAddedGroupForms :
     * @param element 
     */

    @Override
    public void removeAddedGroupForms(String element) {
        SendingHelper.removeAddedGroupForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_ADDEDGROUPFORMS, null, getAddedGroupForms());
}

    /**
     * clearAddedGroupForms :
     */

    @Override
    public void clearAddedGroupForms() {
        SendingHelper.clearAddedGroupForms(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_ADDEDGROUPFORMS, null, getAddedGroupForms());
}

    /**
     * getGroupForms :
     * @return Set<String> 
     */

    @Override
    public Set<String> getGroupForms() {
        Set<String> result = SendingHelper.getGroupForms(getWikitty());
        return result;
}

    /**
     * setGroupForms :
     * @param groupForms 
     */

    @Override
    public void setGroupForms(Set<String> groupForms) {
        Set<String> oldValue = getGroupForms();
        SendingHelper.setGroupForms(getWikitty(), groupForms);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_GROUPFORMS, oldValue, getGroupForms());
}

    /**
     * addAllGroupForms :
     * @param groupForms 
     */

    @Override
    public void addAllGroupForms(Set<String> groupForms) {
        Set<String> oldValue = getGroupForms();
        SendingHelper.addAllGroupForms(getWikitty(), groupForms);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_GROUPFORMS, oldValue, getGroupForms());
}

    /**
     * addGroupForms :
     * @param element 
     */

    @Override
    public void addGroupForms(String element) {
        SendingHelper.addGroupForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_GROUPFORMS, null, getGroupForms());
}

    /**
     * removeGroupForms :
     * @param element 
     */

    @Override
    public void removeGroupForms(String element) {
        SendingHelper.removeGroupForms(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_GROUPFORMS, null, getGroupForms());
}

    /**
     * clearGroupForms :
     */

    @Override
    public void clearGroupForms() {
        SendingHelper.clearGroupForms(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Sending.FIELD_SENDING_GROUPFORMS, null, getGroupForms());
}

    /**
     * SendingAbstract :
     */

    public SendingAbstract() {
        super();
}

    /**
     * SendingAbstract :
     * @param wikitty 
     */

    public SendingAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * SendingAbstract :
     * @param businessEntityImpl 
     */

    public SendingAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionSending =
                new WikittyExtension(EXT_SENDING,
                                     "8.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Date sentDate unique=\"true\"", 
                                             "Date receptionDate unique=\"true\"", 
                                             "String paragraph unique=\"true\"", 
                                             "boolean receptionProof unique=\"true\"", 
                                             "Numeric status unique=\"true\"", 
                                             "String messageId unique=\"true\"", 
                                             "Wikitty user unique=\"true\"", 
                                             "Wikitty deletedGroupForms[0-*] unique=\"true\"", 
                                             "Wikitty addedGroupForms[0-*] unique=\"true\"", 
                                             "Wikitty groupForms[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionSending);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //SendingAbstract
