package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class GroupHelper {

    /**
     * GroupHelper :
     * utility class all provided methods are accessible the static way
     */

    private GroupHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Group.EXT_GROUP, Group.FIELD_GROUP_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(Group.EXT_GROUP, Group.FIELD_GROUP_NAME, name);
        return oldValue;
}

    /**
     * getUser :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getUser(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Group.EXT_GROUP, Group.FIELD_GROUP_USER, String.class);
        return result;
}

    /**
     * setUser :
     * @param wikitty 
     * @param user 
     */

    public static void setUser(Wikitty wikitty, Set<String> user) {
        wikitty.setField(Group.EXT_GROUP, Group.FIELD_GROUP_USER, user);
}

    /**
     * addAllUser :
     * @param wikitty 
     * @param user 
     */

    public static void addAllUser(Wikitty wikitty, Set<String> user) {
        if(user != null){
            for (String id:user){
                addUser(wikitty, id);
            }
        }
}

    /**
     * addUser :
     * @param wikitty 
     * @param element 
     */

    public static void addUser(Wikitty wikitty, String element) {
        wikitty.addToField(Group.EXT_GROUP, Group.FIELD_GROUP_USER, element);
}

    /**
     * removeUser :
     * @param wikitty 
     * @param element 
     */

    public static void removeUser(Wikitty wikitty, String element) {
        wikitty.removeFromField(Group.EXT_GROUP, Group.FIELD_GROUP_USER, element);
}

    /**
     * clearUser :
     * @param wikitty 
     */

    public static void clearUser(Wikitty wikitty) {
        wikitty.clearField(Group.EXT_GROUP, Group.FIELD_GROUP_USER);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Group.EXT_GROUP, Group.FIELD_GROUP_NAME);
            Object f2 = w2.getFieldAsObject(Group.EXT_GROUP, Group.FIELD_GROUP_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Group.EXT_GROUP, Group.FIELD_GROUP_USER);
            Object f2 = w2.getFieldAsObject(Group.EXT_GROUP, Group.FIELD_GROUP_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Group.EXT_GROUP);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : GroupAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //GroupHelper
