/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.coombs;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountingErrorIssue;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.PollenError;
import org.chorem.pollen.votecounting.api.model.PollenErrorIssue;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.impl.coombs.CoombsVoteCountingStrategy;

public class CoombsVoteCounting
extends AbstractVoteCounting {
    public CoombsVoteCounting() {
        super(VoteCountings.Coombs);
    }

    public CoombsVoteCountingStrategy newStrategy() {
        return new CoombsVoteCountingStrategy();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(1.0);
    }

    @Override
    public List<PollenError> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        List<PollenError> errorMap = super.validateVoteForChoice(voteForChoice, config, locale);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue == null) {
            errorMap.add(new PollenError("voteValue", VoteCountingErrorIssue.VOTE_VALUE_REQUIRED, null));
        } else if (voteValue < 0.0) {
            errorMap.add(new PollenError("voteValue", (PollenErrorIssue)VoteCountingErrorIssue.VOTE_VALUE_POSITIVE, (Object)voteValue, voteValue));
        }
        return errorMap;
    }
}

