/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api;

import java.util.List;
import java.util.Locale;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.InvalidVoteCountingConfig;
import org.chorem.pollen.votecounting.api.VoteCountingErrorIssue;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.MinMaxChoicesNumberConfig;
import org.chorem.pollen.votecounting.api.model.PollenError;
import org.chorem.pollen.votecounting.api.model.PollenErrorIssue;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.Voter;

public abstract class AbstractVoteCountingMinMaxChoice
extends AbstractVoteCounting {
    protected AbstractVoteCountingMinMaxChoice(VoteCountings id) {
        super(id);
    }

    @Override
    public MinMaxChoicesNumberConfig createConfig() {
        return new MinMaxChoicesNumberConfig();
    }

    @Override
    public List<PollenError> validateVote(Voter vote, VoteCountingConfig config, Locale locale) {
        long nbChoice;
        List<PollenError> errors = super.validateVote(vote, config, locale);
        MinMaxChoicesNumberConfig minMaxConfig = InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, MinMaxChoicesNumberConfig.class);
        if (minMaxConfig.getMaxChoiceNumber() > 0 && (nbChoice = vote.getVoteForChoices().stream().filter(voteForChoice -> voteForChoice.getVoteValue() != null && voteForChoice.getVoteValue() != 0.0).count()) > (long)minMaxConfig.getMaxChoiceNumber()) {
            errors.add(new PollenError("choices", (PollenErrorIssue)VoteCountingErrorIssue.MAX_CHOICES_OVERFLOW, (Object)nbChoice, locale));
        }
        if (minMaxConfig.getMinChoiceNumber() > 0 && (nbChoice = vote.getVoteForChoices().stream().filter(voteForChoice -> voteForChoice.getVoteValue() != null && voteForChoice.getVoteValue() != 0.0).count()) < (long)minMaxConfig.getMinChoiceNumber()) {
            errors.add(new PollenError("choices", (PollenErrorIssue)VoteCountingErrorIssue.MIN_CHOICES_OVERFLOW, (Object)nbChoice, locale));
        }
        return errors;
    }
}

