/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.chorem.pollen.votecounting.api.VoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.PollenError;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.nuiton.i18n.I18n;

public abstract class AbstractVoteCounting
implements VoteCounting {
    protected final VoteCountings id;
    protected final String i18nName;
    protected final String i18nShortHelp;
    protected final String i18nHelp;

    protected AbstractVoteCounting(VoteCountings id) {
        this.id = id;
        this.i18nName = I18n.n((String)String.format("pollen.voteCountingType.%s", id.getI18nKey()), (Object[])new Object[0]);
        this.i18nShortHelp = I18n.n((String)String.format("pollen.voteCountingType.%s.shortHelp", id.getI18nKey()), (Object[])new Object[0]);
        this.i18nHelp = I18n.n((String)String.format("pollen.voteCountingType.%s.help", id.getI18nKey()), (Object[])new Object[0]);
    }

    @Override
    public final String getName(Locale locale) {
        return I18n.l((Locale)locale, (String)this.i18nName, (Object[])new Object[0]);
    }

    @Override
    public final String getShortHelp(Locale locale) {
        String voteName = I18n.l((Locale)locale, (String)this.i18nName, (Object[])new Object[0]);
        String voteHelp = I18n.l((Locale)locale, (String)this.i18nShortHelp, (Object[])new Object[0]);
        return I18n.l((Locale)locale, (String)"pollen.voteCountingType.help", (Object[])new Object[]{voteName, voteHelp});
    }

    @Override
    public final String getHelp(Locale locale) {
        return I18n.l((Locale)locale, (String)this.i18nHelp, (Object[])new Object[0]);
    }

    @Override
    public VoteCountings getId() {
        return this.id;
    }

    @Override
    public final int getLegacyId() {
        return this.id.getLegacyId();
    }

    @Override
    public List<PollenError> validateVote(Voter vote, VoteCountingConfig config, Locale locale) {
        LinkedList<PollenError> errors = new LinkedList<PollenError>();
        for (VoteForChoice voteForChoice : vote.getVoteForChoices()) {
            List<PollenError> choiceError = this.validateVoteForChoice(voteForChoice, config, locale);
            choiceError.stream().map(error -> error.addPrefixLocation("choice[" + voteForChoice.getChoiceId() + "].")).forEach(errors::add);
        }
        return errors;
    }

    public List<PollenError> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        return List.of();
    }
}

