/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Locale;
import java.util.Map;
import org.chorem.pollen.votecounting.api.VoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.nuiton.i18n.I18n;

public abstract class AbstractVoteCounting
implements VoteCounting {
    protected final VoteCountings id;
    protected final String i18nName;
    protected final String i18nShortHelp;
    protected final String i18nHelp;

    protected AbstractVoteCounting(VoteCountings id) {
        this.id = id;
        this.i18nName = I18n.n((String)String.format("pollen.voteCountingType.%s", id.getI18nKey()), (Object[])new Object[0]);
        this.i18nShortHelp = I18n.n((String)String.format("pollen.voteCountingType.%s.shortHelp", id.getI18nKey()), (Object[])new Object[0]);
        this.i18nHelp = I18n.n((String)String.format("pollen.voteCountingType.%s.help", id.getI18nKey()), (Object[])new Object[0]);
    }

    @Override
    public final String getName(Locale locale) {
        return I18n.l((Locale)locale, (String)this.i18nName, (Object[])new Object[0]);
    }

    @Override
    public final String getShortHelp(Locale locale) {
        String voteName = I18n.l((Locale)locale, (String)this.i18nName, (Object[])new Object[0]);
        String voteHelp = I18n.l((Locale)locale, (String)this.i18nShortHelp, (Object[])new Object[0]);
        return I18n.l((Locale)locale, (String)"pollen.voteCountingType.help", (Object[])new Object[]{voteName, voteHelp});
    }

    @Override
    public final String getHelp(Locale locale) {
        return I18n.l((Locale)locale, (String)this.i18nHelp, (Object[])new Object[0]);
    }

    @Override
    public VoteCountings getId() {
        return this.id;
    }

    @Override
    public final int getLegacyId() {
        return this.id.getLegacyId();
    }

    @Override
    public Multimap<String, String> validateVote(Voter vote, VoteCountingConfig config, Locale locale) {
        ArrayListMultimap errorMap = ArrayListMultimap.create();
        for (VoteForChoice voteForChoice : vote.getVoteForChoices()) {
            Multimap<String, String> choiceError = this.validateVoteForChoice(voteForChoice, config, locale);
            choiceError.entries().forEach(arg_0 -> AbstractVoteCounting.lambda$validateVote$0((Multimap)errorMap, voteForChoice, arg_0));
        }
        return errorMap;
    }

    public Multimap<String, String> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        return ArrayListMultimap.create();
    }

    private static /* synthetic */ void lambda$validateVote$0(Multimap errorMap, VoteForChoice voteForChoice, Map.Entry entry) {
        errorMap.put((Object)("choice[" + voteForChoice.getChoiceId() + "]." + (String)entry.getKey()), (Object)((String)entry.getValue()));
    }
}

