/*
 * #%L
 * Pollen :: Vote Counting
 * 
 * $Id: PercentageMethod.java 3122 2012-01-30 20:43:30Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-votecounting/src/main/java/org/chorem/pollen/votecounting/business/PercentageMethod.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.business;

import java.util.List;

/**
 * Méthode de dépouillement par pourcentage (pondération des choix). Cette
 * méthode étend la méthode standard en ajoutant la pondération des choix.
 *
 * @author rannou
 * @version $Id: PercentageMethod.java 3122 2012-01-30 20:43:30Z tchemit $
 */
public class PercentageMethod extends StandardMethod implements Method {

    @Override
    public double getValueForChoiceByGroup(Choice choice, String idGroup,
            List<String> choicesId) {
        for (String idChoice : choicesId) {
            if (choice.getIdChoice().equals(idChoice)) {
                return choice.getGroup(idGroup).getValue()
                        * choice.getGroup(idGroup).getWeight(); // choice.getGroup(idGroup).getValue() remplace 1

            }
        }
        return 0;
    }
}