/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;

/**
 * Classe DTO représentant un sondage.
 *
 * @version $Id: PollDTO.java 2701 2009-08-12 12:00:59Z nrannou $
 */
public class PollDTO {

    private String pollId = "";

    private String title = "";

    private String description = "";

    private Date beginDate = new Date();

    private Date endDate = null;

    private Date beginChoiceDate = null;

    private int maxChoiceNb = 0;

    private boolean closed = true;

    private boolean choiceAddAllowed = false;

    private boolean anonymousVoteAllowed = false;

    private boolean anonymous = false;

    private boolean publicResults = false;

    private boolean continuousResults = false;

    private PollType pollType = null;

    private VoteCountingType voteCounting = null;

    private ChoiceType choiceType = null;

    private String creatorId = "";

    private String creatorEmail = "";

    private List<VotingGroupDTO> votingGroups = new ArrayList<VotingGroupDTO>();

    private List<PollChoiceDTO> choices = new ArrayList<PollChoiceDTO>();

    private List<CommentDTO> comments = new ArrayList<CommentDTO>();

    public PollDTO() {

    }

    public PollDTO(String pollId) {
        this.pollId = pollId;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getBeginChoiceDate() {
        return beginChoiceDate;
    }

    public void setBeginChoiceDate(Date beginChoiceDate) {
        this.beginChoiceDate = beginChoiceDate;
    }

    public int getMaxChoiceNb() {
        return maxChoiceNb;
    }

    public void setMaxChoiceNb(int maxChoiceNb) {
        this.maxChoiceNb = maxChoiceNb;
    }

    public boolean isClosed() {
        return closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isChoiceAddAllowed() {
        return choiceAddAllowed;
    }

    public void setChoiceAddAllowed(boolean choiceAddAllowed) {
        this.choiceAddAllowed = choiceAddAllowed;
    }

    public boolean isAnonymousVoteAllowed() {
        return anonymousVoteAllowed;
    }

    public void setAnonymousVoteAllowed(boolean anonymousVoteAllowed) {
        this.anonymousVoteAllowed = anonymousVoteAllowed;
    }

    public boolean isAnonymous() {
        return anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isPublicResults() {
        return publicResults;
    }

    public void setPublicResults(boolean publicResults) {
        this.publicResults = publicResults;
    }

    public boolean isContinuousResults() {
        return continuousResults;
    }

    public void setContinuousResults(boolean continuousResults) {
        this.continuousResults = continuousResults;
    }

    public PollType getPollType() {
        return pollType;
    }

    public void setPollType(PollType pollType) {
        this.pollType = pollType;
    }

    public VoteCountingType getVoteCounting() {
        return voteCounting;
    }

    public void setVoteCounting(VoteCountingType voteCounting) {
        this.voteCounting = voteCounting;
    }

    public ChoiceType getChoiceType() {
        return choiceType;
    }

    public void setChoiceType(ChoiceType choiceType) {
        this.choiceType = choiceType;
    }

    public String getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorEmail() {
        return creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public List<VotingGroupDTO> getVotingGroups() {
        return votingGroups;
    }

    public void setVotingGroups(List<VotingGroupDTO> votingGroups) {
        this.votingGroups = votingGroups;
    }

    public List<PollChoiceDTO> getChoices() {
        return choices;
    }

    public void setChoices(List<PollChoiceDTO> choices) {
        this.choices = choices;
    }

    public List<CommentDTO> getComments() {
        return comments;
    }

    public void setComments(List<CommentDTO> comments) {
        this.comments = comments;
    }
}