/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.CommentDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.PollExportDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.chorem.pollen.votecounting.services.ServiceExport;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PollExportXML
implements ServiceExport {
    private PollDTO poll;
    private List<VoteCountingResultDTO> voteCountingResults;
    private static String PATH_FILE;
    private static Element racine;
    static Document document;
    private static final Log log;

    private String process() {
        racine = new Element("pollExport");
        document = new Document(racine);
        Element pollElm = new Element("poll");
        pollElm.setAttribute(new Attribute("idPoll", this.poll.getIdPoll()));
        pollElm.setAttribute(new Attribute("typePoll", this.poll.getTypePoll().name()));
        pollElm.setAttribute("typeVoteCounting", this.poll.getTypeVoteCounting().name());
        Element maxChoicesByPersonElm = new Element("maxChoicesByPerson");
        maxChoicesByPersonElm.setText(Integer.toString(this.poll.getMaxChoicesByPerson()));
        pollElm.addContent((Content)maxChoicesByPersonElm);
        Element titleElm = new Element("title");
        titleElm.setText(this.poll.getTitle());
        pollElm.addContent((Content)titleElm);
        Element descriptionElm = new Element("description");
        descriptionElm.setText(this.poll.getDescription());
        pollElm.addContent((Content)descriptionElm);
        Element commentsElm = new Element("comments");
        ListIterator<CommentDTO> iteratorComment = this.poll.getComments().listIterator();
        while (iteratorComment.hasNext()) {
            Element commentElm = new Element("comment");
            CommentDTO comment = (CommentDTO)iteratorComment.next();
            commentElm.setAttribute(new Attribute("votingKey", comment.getVotingID()));
            commentElm.setText(comment.getText());
            commentsElm.addContent((Content)commentElm);
        }
        pollElm.addContent((Content)commentsElm);
        Element groupsElm = new Element("groups");
        ListIterator<VotingGroupDTO> iteratorGroup = this.poll.getVotingGroups().listIterator();
        while (iteratorGroup.hasNext()) {
            Element groupElm = this.save((VotingGroupDTO)iteratorGroup.next());
            groupsElm.addContent((Content)groupElm);
        }
        pollElm.addContent((Content)groupsElm);
        Element pollChoicesElm = new Element("pollChoices");
        ListIterator<PollChoiceDTO> iteratorpollChoices = this.poll.getChoices().listIterator();
        while (iteratorpollChoices.hasNext()) {
            Element pollChoiceElm = this.save((PollChoiceDTO)iteratorpollChoices.next());
            pollChoicesElm.addContent((Content)pollChoiceElm);
        }
        pollElm.addContent((Content)pollChoicesElm);
        Element voteCountingResultsElm = new Element("voteCountingResults");
        ListIterator<VoteCountingResultDTO> iteratorvoteCountingResults = this.voteCountingResults.listIterator();
        while (iteratorvoteCountingResults.hasNext()) {
            Element voteCountingResult = this.save((VoteCountingResultDTO)iteratorvoteCountingResults.next());
            voteCountingResultsElm.addContent((Content)voteCountingResult);
        }
        racine.addContent((Content)pollElm);
        racine.addContent((Content)voteCountingResultsElm);
        this.affiche();
        this.enregistre();
        return PATH_FILE;
    }

    public Element save(VotingGroupDTO group) {
        Element groupElm = new Element("group");
        Attribute groupIdAtt = new Attribute("idGroup", group.getIdGroup());
        Attribute weightdAtt = new Attribute("weight", Double.toString(group.getWeight()));
        groupElm.setAttribute(groupIdAtt);
        groupElm.setAttribute(weightdAtt);
        Element votingPersonsElm = new Element("votingPersons");
        ListIterator<VotingPersonDTO> iteratorVotingPersons = group.getVotingPersons().listIterator();
        while (iteratorVotingPersons.hasNext()) {
            Element votingPersonElm = this.save((VotingPersonDTO)iteratorVotingPersons.next());
            votingPersonsElm.addContent((Content)votingPersonElm);
        }
        groupElm.addContent((Content)votingPersonsElm);
        return groupElm;
    }

    public Element save(VotingPersonDTO votingPerson) {
        Element votingPersonElm = new Element("votingPerson");
        Attribute votingKeyAtt = new Attribute("votingKey", votingPerson.getVotingKey());
        Attribute weightdAtt = new Attribute("weight", Double.toString(votingPerson.getWeight()));
        votingPersonElm.setAttribute(votingKeyAtt);
        votingPersonElm.setAttribute(weightdAtt);
        Element emailElm = new Element("email");
        emailElm.setText(votingPerson.getEmail());
        votingPersonElm.addContent((Content)emailElm);
        Element commentElm = new Element("comment");
        commentElm.setText(votingPerson.getComment());
        votingPersonElm.addContent((Content)commentElm);
        Element choicesElm = new Element("choices");
        ListIterator<VoteToChoiceDTO> iteratorChoices = votingPerson.getChoices().listIterator();
        while (iteratorChoices.hasNext()) {
            VoteToChoiceDTO voteToChoice = (VoteToChoiceDTO)iteratorChoices.next();
            Element choiceElm = new Element("choice");
            choiceElm.setAttribute("idChoice", voteToChoice.getIdChoice());
            choiceElm.setAttribute("value", Double.toString(voteToChoice.getValue()));
            choicesElm.addContent((Content)choiceElm);
        }
        votingPersonElm.addContent((Content)choicesElm);
        return votingPersonElm;
    }

    public Element save(VoteToChoiceDTO voteToChoice) {
        return null;
    }

    public Element save(PollChoiceDTO pollChoice) {
        Element pollChoiceElm = new Element("pollChoice");
        pollChoiceElm.setAttribute("idChoice", pollChoice.getIdChoice());
        Element nameElm = new Element("name");
        nameElm.setText(pollChoice.getName());
        pollChoiceElm.addContent((Content)nameElm);
        Element descriptionElm = new Element("description");
        descriptionElm.setText(pollChoice.getDescription());
        pollChoiceElm.addContent((Content)descriptionElm);
        return pollChoiceElm;
    }

    public Element save(VoteCountingResultDTO voteCountingResults) {
        Element voteCountingResultElm = new Element("voteCountingResult");
        voteCountingResultElm.setAttribute("idPoll", voteCountingResults.getIdPoll());
        Element nbVotesElm = new Element("nbVotes");
        nbVotesElm.setText(Integer.toString(voteCountingResults.getNbVotes()));
        voteCountingResultElm.addContent((Content)nbVotesElm);
        Element choiceResultElm = new Element("choiceResult");
        choiceResultElm.setText(voteCountingResults.getChoiceResult());
        voteCountingResultElm.addContent((Content)choiceResultElm);
        Element isByGroupElm = new Element("isByGroup");
        isByGroupElm.setText(Boolean.toString(voteCountingResults.isByGroup()));
        voteCountingResultElm.addContent((Content)isByGroupElm);
        Element choicesElm = new Element("choices");
        ListIterator<ChoiceDTO> iteratorChoices = voteCountingResults.getChoices().listIterator();
        while (iteratorChoices.hasNext()) {
            Element choiceElm = this.save((ChoiceDTO)iteratorChoices.next());
            choicesElm.addContent((Content)choiceElm);
        }
        voteCountingResultElm.addContent((Content)choicesElm);
        return voteCountingResultElm;
    }

    public Element save(ChoiceDTO choice) {
        Element choiceElm = new Element("choice");
        choiceElm.setAttribute("idChoice", choice.getIdChoice());
        choiceElm.setAttribute("value", Double.toString(choice.getValue()));
        Element percentageElm = new Element("percentage");
        percentageElm.setText(Double.toString(choice.getPercentage()));
        choiceElm.addContent((Content)percentageElm);
        Element nbVotesElm = new Element("nbVotes");
        nbVotesElm.setText(Integer.toString(choice.getNbVotes()));
        choiceElm.addContent((Content)nbVotesElm);
        return choiceElm;
    }

    private void affiche() {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(document, (OutputStream)System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void enregistre() {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(document, (OutputStream)new FileOutputStream(PATH_FILE));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fileName() {
        PATH_FILE = "edi" + this.poll.getIdPoll() + ".xml";
    }

    @Override
    public String executeExport(PollExportDTO pollExport) {
        this.poll = pollExport.getPoll();
        this.voteCountingResults = pollExport.getVoteCountingResults();
        this.fileName();
        return this.process();
    }

    @Override
    public PollExportDTO executeImport(String path) {
        SAXBuilder sxb = new SAXBuilder();
        try {
            document = sxb.build(new File(path));
        }
        catch (Exception exception) {
            // empty catch block
        }
        racine = document.getRootElement();
        if (racine == null && log.isErrorEnabled()) {
            log.error((Object)"racine null");
        }
        return this.loadPoll();
    }

    private PollExportDTO loadPoll() {
        Element pollElm = racine.getChild("poll");
        PollDTO poll = new PollDTO(pollElm.getAttributeValue("idPoll"), Integer.parseInt(pollElm.getChild("maxChoicesByPerson").getText()), PollType.valueOf(pollElm.getAttributeValue("typePoll")), VoteCountingType.valueOf(pollElm.getAttributeValue("typeVoteCounting")));
        poll.setTitle(pollElm.getChild("title").getText());
        poll.setDescription(pollElm.getChild("description").getText());
        Element commentsElm = pollElm.getChild("comments");
        List listComments = commentsElm.getChildren("comment");
        List vectorComments = this.loadComments(listComments);
        Element groupsElm = pollElm.getChild("groups");
        List listGroups = groupsElm.getChildren("group");
        List vectorGroups = this.loadGroups(listGroups);
        Element pollChoicesElm = pollElm.getChild("pollChoices");
        List listPollChoices = pollChoicesElm.getChildren("pollChoice");
        List vectorPollChoices = this.loadPollChoices(listPollChoices);
        Element voteCountingResultsElm = racine.getChild("voteCountingResults");
        List listVoteCountingResults = voteCountingResultsElm.getChildren("voteCountingResult");
        List vectorVoteCountingResults = this.loadVoteCountingResults(listVoteCountingResults);
        poll.setComments(vectorComments);
        poll.setVotingGroups(vectorGroups);
        poll.setChoices(vectorPollChoices);
        PollExportDTO pollExport = new PollExportDTO();
        pollExport.setIdPoll(poll.getIdPoll());
        pollExport.setPoll(poll);
        pollExport.setVoteCountingResults(vectorVoteCountingResults);
        return pollExport;
    }

    private List loadComments(List<Element> listComments) {
        ArrayList<CommentDTO> vectorComments = new ArrayList<CommentDTO>();
        ListIterator<Element> i = listComments.listIterator();
        while (i.hasNext()) {
            Element commentElm = (Element)i.next();
            CommentDTO comment = new CommentDTO(commentElm.getAttributeValue("votingKey"), commentElm.getText());
            vectorComments.add(comment);
        }
        return vectorComments;
    }

    private List loadGroups(List<Element> listGroups) {
        ArrayList<VotingGroupDTO> vectorGroups = new ArrayList<VotingGroupDTO>();
        ListIterator<Element> i = listGroups.listIterator();
        while (i.hasNext()) {
            Element groupElm = (Element)i.next();
            VotingGroupDTO group = new VotingGroupDTO(groupElm.getAttributeValue("idGroup"), Double.parseDouble(groupElm.getAttributeValue("weight")));
            Element votingPersonsElm = groupElm.getChild("votingPersons");
            List listVotingPersons = votingPersonsElm.getChildren("votingPerson");
            List vectorVotingPersons = this.loadVotingPersons(listVotingPersons);
            group.setVotingPersons(vectorVotingPersons);
            vectorGroups.add(group);
        }
        return vectorGroups;
    }

    List loadVotingPersons(List<Element> listVotingPersons) {
        ArrayList<VotingPersonDTO> vectorVotingPersons = new ArrayList<VotingPersonDTO>();
        ListIterator<Element> i = listVotingPersons.listIterator();
        while (i.hasNext()) {
            Element votingPersonElm = (Element)i.next();
            VotingPersonDTO votingPerson = new VotingPersonDTO(votingPersonElm.getAttributeValue("votingKey"), Double.parseDouble(votingPersonElm.getAttributeValue("weight")));
            votingPerson.setEmail(votingPersonElm.getChild("email").getValue());
            votingPerson.setComment(votingPersonElm.getChild("comment").getValue());
            Element choicesElm = votingPersonElm.getChild("choices");
            List listVoteTOChoices = choicesElm.getChildren("choice");
            List vectorVoteTOChoices = this.loadVoteTOChoices(listVoteTOChoices);
            votingPerson.setChoices(vectorVoteTOChoices);
            vectorVotingPersons.add(votingPerson);
        }
        return vectorVotingPersons;
    }

    List loadVoteTOChoices(List<Element> listVoteToChoices) {
        ArrayList<VoteToChoiceDTO> vectorVoteToChoices = new ArrayList<VoteToChoiceDTO>();
        ListIterator<Element> i = listVoteToChoices.listIterator();
        while (i.hasNext()) {
            Element voteToChoiceElm = (Element)i.next();
            VoteToChoiceDTO voteToChoice = new VoteToChoiceDTO(voteToChoiceElm.getAttributeValue("idChoice"), Double.parseDouble(voteToChoiceElm.getAttributeValue("value")));
            vectorVoteToChoices.add(voteToChoice);
        }
        return vectorVoteToChoices;
    }

    List loadPollChoices(List<Element> listPollChoices) {
        ArrayList<PollChoiceDTO> vectorPollChoices = new ArrayList<PollChoiceDTO>();
        ListIterator<Element> i = listPollChoices.listIterator();
        while (i.hasNext()) {
            Element pollChoiceElm = (Element)i.next();
            PollChoiceDTO pollChoice = new PollChoiceDTO(pollChoiceElm.getAttributeValue("idChoice"));
            pollChoice.setName(pollChoiceElm.getChild("name").getValue());
            pollChoice.setDescription(pollChoiceElm.getChild("description").getValue());
            vectorPollChoices.add(pollChoice);
        }
        return vectorPollChoices;
    }

    List loadVoteCountingResults(List<Element> listVoteCountingResults) {
        ArrayList<VoteCountingResultDTO> vectorVoteCountingResults = new ArrayList<VoteCountingResultDTO>();
        ListIterator<Element> i = listVoteCountingResults.listIterator();
        while (i.hasNext()) {
            Element voteCountingResultElm = (Element)i.next();
            VoteCountingResultDTO voteCountingResult = new VoteCountingResultDTO();
            voteCountingResult.setIdPoll(voteCountingResultElm.getAttributeValue("idPoll"));
            voteCountingResult.setNbVotes(Integer.parseInt(voteCountingResultElm.getChild("nbVotes").getValue()));
            voteCountingResult.setChoiceResult(voteCountingResultElm.getChild("choiceResult").getValue());
            voteCountingResult.setByGroup(Boolean.parseBoolean(voteCountingResultElm.getChild("isByGroup").getValue()));
            Element choicesElm = voteCountingResultElm.getChild("choices");
            List listChoices = choicesElm.getChildren("choice");
            List vectorChoices = this.loadChoices(listChoices);
            voteCountingResult.setChoices(vectorChoices);
            vectorVoteCountingResults.add(voteCountingResult);
        }
        return vectorVoteCountingResults;
    }

    List loadChoices(List<Element> listChoices) {
        ArrayList<ChoiceDTO> vectorChoices = new ArrayList<ChoiceDTO>();
        ListIterator<Element> i = listChoices.listIterator();
        while (i.hasNext()) {
            Element choiceElm = (Element)i.next();
            ChoiceDTO choice = new ChoiceDTO(choiceElm.getAttribute("idChoice").getName(), Double.parseDouble(choiceElm.getAttribute("value").getValue()), Double.parseDouble(choiceElm.getChild("percentage").getValue()), Integer.parseInt(choiceElm.getChild("nbVotes").getValue()));
            vectorChoices.add(choice);
        }
        return vectorChoices;
    }

    static {
        log = LogFactory.getLog(PollExportXML.class);
    }
}

