/*
 * #%L
 * Pollen :: VoteCounting Api
 * $Id: ChoiceScore.java 3593 2012-08-12 11:01:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-votecounting-api/src/main/java/org/chorem/pollen/votecounting/model/ChoiceScore.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.model;

import java.math.BigDecimal;

/**
 * ChoiceScore for a given choice.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class ChoiceScore implements ChoiceIdAble, Comparable<ChoiceScore> {

    /** Id of the choice. */
    private String choiceId;

    /** Score for this choice. */
    private BigDecimal scoreValue;

    public static ChoiceScore newScore(String choiceId, BigDecimal scoreValue) {
        ChoiceScore choiceScore = new ChoiceScore();
        choiceScore.setChoiceId(choiceId);
        choiceScore.setScoreValue(scoreValue);
        return choiceScore;
    }

    @Override
    public String getChoiceId() {
        return choiceId;
    }

    public BigDecimal getScoreValue() {
        return scoreValue;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public void addScoreValue(double scoreToAdd) {
        BigDecimal newScoreValue;
        if (scoreValue == null) {

            newScoreValue = BigDecimal.valueOf(scoreToAdd);
        } else {
            newScoreValue = scoreValue.add(BigDecimal.valueOf(scoreToAdd));
        }
        setScoreValue(newScoreValue);
    }

    public void setScoreValue(BigDecimal scoreValue) {
        this.scoreValue = scoreValue;
    }

    @Override
    public int compareTo(ChoiceScore o) {
        int i1 = scoreValue == null ? -1 : scoreValue.intValue();
        int i2 = o.scoreValue == null ? -1 : o.scoreValue.intValue();
        return i1 - i2;
//        BigDecimal v1 = scoreValue;
//        BigDecimal v2 = o.scoreValue;
//        if (v1 == null) {
//            v1 = new BigDecimal(-1);
//        }
//        if (v2 == null) {
//            v2 = new BigDecimal(-1);
//        }
//        int i = v1.subtract(v2).intValue();
//        return i;
    }
}
