/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.strategy;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.strategy.VoteCountigStrategyNotFound;
import org.chorem.pollen.votecounting.strategy.VoteCountingStrategy;

public class VoteCountingStrategyProvider {
    private static final Log log = LogFactory.getLog(VoteCountingStrategyProvider.class);
    private final Map<Integer, VoteCountingStrategy> strategies = this.load();

    public Set<Integer> getStrategyIds() {
        return ImmutableSet.copyOf(this.strategies.keySet());
    }

    public VoteCountingStrategy getStrategy(int strategyId) throws VoteCountigStrategyNotFound {
        VoteCountingStrategy type = this.strategies.get(strategyId);
        if (type == null) {
            throw new VoteCountigStrategyNotFound("Could not find strategy with id " + strategyId);
        }
        try {
            return (VoteCountingStrategy)type.getClass().newInstance();
        }
        catch (Exception e) {
            throw new VoteCountigStrategyNotFound("Could not instanciate stragegy " + strategyId, e);
        }
    }

    protected Map<Integer, VoteCountingStrategy> load() {
        TreeMap result = Maps.newTreeMap();
        ServiceLoader<VoteCountingStrategy> loader = ServiceLoader.load(VoteCountingStrategy.class);
        for (VoteCountingStrategy strategy : loader) {
            int id = strategy.getId();
            if (result.containsKey(id)) {
                throw new IllegalStateException("Strategy [" + strategy.getI18nName() + "] with id " + id + ", can not be used since the id is already used " + "by strategy [" + ((VoteCountingStrategy)result.get(id)).getI18nName() + "] ");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Detected strategy [" + id + "-" + strategy.getI18nName() + "] : " + strategy.getClass().getName()));
            }
            result.put(id, strategy);
        }
        return result;
    }
}

