/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

public class DeleteVote
extends PollenActionSupport
implements PollenUserSecurityAware,
PollUriAware {
    private static final long serialVersionUID = 1L;
    protected String voteId;
    protected String reason;

    public void setVoteId(String voteId) {
        this.voteId = voteId;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.voteId);
        Poll poll = this.getUserSecurityContext().getPoll();
        this.getVoteService().deleteVote(poll, this.voteId, this.reason);
        this.addFlashMessage(this._("pollen.information.vote.deleted", new Object[0]));
        if (poll.isPollFree() && this.getUserSecurityContext().isWithAccountId()) {
            String userAccountId = this.getUserSecurityContext().getAccountId();
            String creatorId = this.getUserSecurityContext().getPoll().getCreator().getAccountId();
            if (!creatorId.equals(userAccountId)) {
                this.getPollUri().setAccountId(null);
            }
        }
        return "success";
    }
}

