<%--
  #%L
  Pollen :: UI (struts2)
  $Id: createdList.jsp 3775 2013-04-22 20:49:16Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/user/createdList.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>

<link rel="stylesheet" type="text/css" href="<s:url value='/css/tipTip.css'/>"/>

<style type="text/css">
  legend {
    color: #727a7e;
    font-weight: bold;
  }
</style>
<script type="text/javascript"
        src='<s:url value="/js/jquery.tipTip.minified.js"/>'></script>

<script type="text/javascript">
  var redirectUrl = '<s:url namespace="/user" action="createdList"/>';
  $(function () {
    $('img[src$="tooltip.png"]').addClass('tooltip');
    $(".tooltip").tipTip();
  });
</script>
<%@include file="/WEB-INF/jsp/pollListHelper.jsp" %>

<title><s:text name="pollen.title.pollsCreatedList"/></title>

<h1 class="title<s:property value='%{pageLogo}'/>">
  <s:text name="pollen.title.pollsCreatedList"/>
</h1>

<h4><s:text name="pollen.title.pollsCreatedList.legend"/></h4>

<s:url id="loadUrl" action="getCreatedPolls" namespace="/json"
       escapeAmp="false"/>

<sjg:grid id="polls" dataType="json" href="%{loadUrl}" gridModel="data"
          sortable="true" pager="true" pagerButtons="true" pagerInput="true"
          navigator="true" rownumbers="false" autowidth="true"
          onSelectRowTopics='users-rowSelect' editurl="%{loadUrl}"
          onCompleteTopics='users-cleanSelect'
          navigatorEdit="false" navigatorDelete="false"
          navigatorSearch="false" navigatorRefresh="false"
          navigatorAdd="false" viewrecords="true"
          rowList="10,15,20,50,100" rowNum="10">
  <sjg:gridColumn name="id" title="id" hidden="true"/>

  <sjg:gridColumn name="title" title='%{getText("pollen.common.title")}'/>
  <sjg:gridColumn name="description"
                  title='%{getText("pollen.common.description")}'/>
  <sjg:gridColumn name="topiaCreateDate" width="115"
                  title='%{getText("pollen.common.createDate")}'/>
  <sjg:gridColumn name="addingChoices" sortable="false"
                  title='%{getText("pollen.common.addingChoices")}'/>
  <sjg:gridColumn name="beginDate" width="100"
                  title='%{getText("pollen.common.beginDate")}'/>
  <sjg:gridColumn name="endDate" width="100"
                  title='%{getText("pollen.common.endDate")}'/>
  <sjg:gridColumn name="functions" title='%{getText("pollen.common.functions")}'
                  formatter="pollFunctions" width="75" sortable="false"/>
</sjg:grid>

<br/>
<fieldset>
  <legend><s:text name="pollen.legend.attachPoll"/>
    <img src="<s:url value='/img/tooltip.png'/>"
         title="<s:text name='poll.help.attachPoll'/>"
         alt="<s:text name='poll.help.attachPoll'/>"/>
  </legend>

  <s:form namespace="/user" method="POST">

    <s:textfield key="pollId" label='%{getText("pollen.common.pollId")}'
                 requiredLabel="true" size="80" tooltipIconPath="/img/tooltip.png"
                 tooltip='%{getText("poll.help.pollId")}'/>

    <br/>
    <s:submit action="attachPoll" key="pollen.action.attachPoll"/>
  </s:form>
</fieldset>
