/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: AttachPoll.java 3604 2012-08-13 14:02:08Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/AttachPoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * To attach a anonymous poll to a connected user account.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class AttachPoll extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(AttachPoll.class);

    /**
     * Id of the poll to attach to the connected user account.
     *
     * @since 1.4.5
     */
    private String pollId;

    public AttachPoll() {
        super(PageSkin.EDITION);
    }

    public String getPollId() {
        return pollId == null ? null : pollId.trim();
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    @Override
    public String execute() throws Exception {

        String id = getPollId();

        UserAccount userAccount = getPollenUserAccount();

        Poll poll = getPollService().getExistingPollByPollId(id);

        if (log.isInfoEnabled()) {
            log.info(String.format("Will attach poll %s to user %s",
                                   id, userAccount.getEmail()));
        }

        getPollService().attachPoll(id, userAccount);

        addFlashMessage(_("pollen.information.poll.attached", poll.getTitle()));

        return SUCCESS;
    }

    @Override
    public void validate() {

        String id = getPollId();

        if (StringUtils.isBlank(id)) {
            addFieldError("pollId", _("pollen.error.pollId.empty"));
        } else {

            try {

                // check that poll exists
                Poll poll = getPollService().getExistingPollByPollId(id);

                // check that poll is not yet attached to another user account

                UserAccount userAccount = poll.getCreator().getUserAccount();
                if (userAccount != null) {

                    addFieldError("pollId", _("pollen.error.pollAlreadyAttached"));
                }
            } catch (PollNotFoundException e) {

                addFieldError("pollId", _("pollen.error.pollNotFound"));
            }

        }
    }
}
