package org.chorem.pollen.ui.actions.user;
/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: CreateFavoriteListVoter.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/CreateFavoriteListVoter.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.exceptions.FavoriteListNotFoundException;
import org.chorem.pollen.services.exceptions.FavoriteListNotOwnedByUserException;
import org.chorem.pollen.services.exceptions.ParticipantAlreadyFoundInListException;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;
import org.nuiton.util.StringUtil;

/**
 * Creates a new {@link PollAccount} inside a selected {@link PersonList}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class CreateFavoriteListVoter extends PollenActionSupportForEdition implements Preparable, ParameterAware {

    private static final long serialVersionUID = 1L;

    protected PersonList favoriteList;

    protected PollAccount pollAccount;

    public PollAccount getCreatePollAccount() {
        return getPollAccount();
    }

    public PersonList getFavoriteList() {
        return favoriteList;
    }

    public String getFavoriteListId() {
        return favoriteList.getTopiaId();
    }

    public String getAction() {
        return "create";
    }

    @Override
    public void prepare() throws Exception {

        String[] favoriteListIds = getParameters().get("favoriteListId");
        Preconditions.checkNotNull(favoriteListIds);
        Preconditions.checkArgument(favoriteListIds.length == 1);
        String favoriteListId = favoriteListIds[0];

        try {
            favoriteList = getFavoriteService().getFavoriteList(
                    getPollenUserAccount(), favoriteListId);
        } catch (FavoriteListNotFoundException e) {
            addFlashError(_("pollen.error.favoriteList.not.found"));
        } catch (FavoriteListNotOwnedByUserException e) {
            addFlashError(_("pollen.error.favoriteList.not.owned.by.user"));
        }
    }

    @Override
    public void validate() {

        PollAccount account = getCreatePollAccount();

        if (StringUtils.isBlank(account.getVotingId())) {
            addFieldError("createPollAccount.votingId",
                          _("pollen.error.pollAccount.votingId.required"));
        }

        if (StringUtils.isBlank(account.getEmail())) {
            addFieldError("createPollAccount.email",
                          _("pollen.error.email.required"));
        } else if (!StringUtil.isEmail(account.getEmail())) {
            addFieldError("createPollAccount.email",
                          _("pollen.error.email.invalid"));
        }

    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(favoriteList);
        Preconditions.checkNotNull(pollAccount);

        String result = INPUT;

        try {

            getFavoriteService().addPollAccountToFavoriteList(
                    favoriteList, pollAccount);

            addFlashMessage(
                    _("pollen.information.pollAccount.addedTofavoriteList",
                      pollAccount.getVotingId()));

            pollAccount = null;
            result = SUCCESS;
        } catch (ParticipantAlreadyFoundInListException e) {
            addFieldError("createPollAccount.email",
                          _("pollen.error.favoriteList.participant.already.found.in.list"));
        }
        return result;
    }

    protected PollAccount getPollAccount() {
        if (pollAccount == null) {
            pollAccount = getFavoriteService().newPollAccountForFavoriteList();
        }
        return pollAccount;
    }
}