/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GetPollImageChoice.java 3542 2012-06-20 10:46:32Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/io/GetPollImageChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.ui.actions.PollenActionSupport;

import javax.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLDecoder;

/**
 * Obtain the image choice of a given choice of an image-like poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetPollImageChoice extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String choiceTokenId;

    protected String pollId;

    protected String choiceId;

    protected boolean thumb;

    protected transient InputStream inputStream;

    protected String contentType;

    public void setChoiceTokenId(String choiceTokenId) {
        this.choiceTokenId = choiceTokenId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public void setThumb(boolean thumb) {
        this.thumb = thumb;
    }

    public String getContentType() {
        return contentType;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    @Override
    public String execute() throws Exception {

        File file;

        if (StringUtils.isNotBlank(choiceTokenId)) {

            // use location from session
            file = getPollenSession().getDynamicData(choiceTokenId);
        } else {

            // using pollId / choiceId to find image to render

            Preconditions.checkNotNull(pollId);
            Preconditions.checkNotNull(choiceId);

            // decode choice Id
            String choiceName = URLDecoder.decode(choiceId,
                                                  Charsets.UTF_8.name());

            file = getPollService().getPollChoiceImageFile(pollId, choiceName);

            if (thumb) {

                file = getPollService().getImageThumbFile(file);
            }
        }

        MimetypesFileTypeMap mimes = new MimetypesFileTypeMap();
        contentType = mimes.getContentType(file);

        inputStream = new FileInputStream(file);

        return SUCCESS;
    }
}
