<%--
  #%L
  Pollen :: UI (struts2)
  $Id: result.jsp 3524 2012-06-19 12:22:07Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/poll/result.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/results.css'/>"/>
<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/jquery.lightbox-0.5.css'/>"/>


<script type="text/javascript"
        src="<s:url value='/js/jquery.lightbox-0.5.js' />"></script>

<script type="text/javascript">

  function displayCharts(type) {
    $.each(chartUrls, function (key, value) {
      var url = value + "&type=" + type;
      $('#' + key).attr("src", url);
    });
    return false;
  }

  var chartUrls = {};

  chartUrls['chart_normal'] = "<s:url value='%{getNormalPollResultChartUrl(400, 300)}' escapeAmp='false'/>";
  <s:if test="numberVoteCounting">
  <s:iterator value="choicesResultNames" var="choicesResultName" status="status">
  chartUrls['chart_<s:property value="#status.index"/>'] = "<s:url value='%{getChoicesResultCharUrl(400,300, #choicesResultName)}' escapeAmp='false'/>";
  </s:iterator>
  </s:if>

  jQuery(document).ready(function () {

    // register all chart url (without the type in it)
    displayCharts(1);

    $('a[rel*="lightbox"]').lightBox(
      {
        imageLoading:'<s:url value="/img/lightbox-ico-loading.gif"/>',
        imageBtnClose:'<s:url value="/img/lightbox-btn-close.gif"/>',
        imageBtnPrev:'<s:url value="/img/lightbox-btn-prev.gif"/>',
        imageBtnNext:'<s:url value="/img/lightbox-btn-next.gif"/>'
      });

  });
</script>

<h1 class="titleVoteCounting"><s:property value="poll.title"/></h1>

<!-- Informations sur le sondage -->
<div id="resultTop">
  <div style="white-space:pre-wrap; text-align: start;">
    <s:property value="poll.description"/>
  </div>
  <fieldset>
    <legend><s:text name="pollen.common.aboutPoll"/></legend>
    <div style="float: right">
      <s:if test="creatorOrAdmin">
        <s:a href="%{summaryUrl}">
          <img src="<s:url value='/img/editSmall.png'/>"
               title="<s:text name='pollen.action.summaryPoll'/>"
               alt="<s:text name='pollen.action.summaryPoll'/>"/>
        </s:a>
      </s:if>
      <s:a href='%{voteUrl}'>
        <img src="<s:url value='/img/vote.png'/>"
             title="<s:text name="pollen.common.vote.return-help"/>"
             alt="<s:text name="pollen.common.vote.return"/>"/>
      </s:a>
      <s:if test="feedFileExisting">
        <s:a namespace="/poll" action="getFeed">
          <s:param name="pollId" value="poll.pollId"/>
          <img src="<s:url value='/img/feed.png'/>" title="Atom" alt="Atom"/>
        </s:a>
      </s:if>
    </div>
    <s:label value="%{poll.creator.votingId}"
             key='pollen.common.pollCreator'/>
    <s:label value="%{poll.beginDate}" key='pollen.common.beginDate'/>
    <s:label value="%{poll.endDate}"
             label='%{getText("pollen.common.endDate")}'/>
    <s:label value="%{poll.voteCountingType}"
             label='%{getText("pollen.common.voteCountingType")}'
             tooltip="%{getVoteCountingTypeHelp(poll.voteCountingType)}"
             tooltipIconPath="/img/tooltip.png"/>
  </fieldset>
</div>

<!-- Victoire -->
<s:if test="victoryMessage != ''">
  <h4><s:property value="victoryMessage"/>
    <br/>
    <s:iterator value="topRanking" var="result">
      <s:if test="textType">
        <s:property value="name"/>
      </s:if>
      <s:elseif test="dateType">
        <s:property value="%{getResultAsDate(#result)}"/>
      </s:elseif>
      <s:elseif test="imageType">
        <s:url id="imageUrl" namespace="/io" action="getPollChoiceImage"
               escapeAmp="false">
          <s:param name="choiceId" value="name"/>
          <s:param name="pollId" value="poll.pollId"/>
          <s:param name="thumb" value="false"/>
        </s:url>
        <s:url id="imageUrlThumb" namespace="/io" action="getPollChoiceImage"
               escapeAmp="false">
          <s:param name="choiceId" value="name"/>
          <s:param name="pollId" value="poll.pollId"/>
          <s:param name="thumb" value="true"/>
        </s:url>
        <a href="<s:property value='imageUrl'/>" rel="lightbox">
          <img alt="<s:property value='name'/>"
               title="<s:property value='name'/>"
               src="<s:property value='imageUrlThumb'/>">
        </a>

      </s:elseif>
      <br/>
    </s:iterator>
  </h4>
</s:if>

<!-- Diagramme -->
<div id="resultChart">
  <div class="chartTypeDiv">
    <sj:a id='displayChart1' href="#" onclick="return displayCharts(1);">
      <img src="<s:url value='/img/rep1.png'/>"
           title='<s:text name="pollen.common.chartType-pie"/>' alt="1"/>
    </sj:a>
    <sj:a id='displayChart2' href="#" onclick="return displayCharts(2);">
      <img src="<s:url value='/img/rep2.png'/>"
           title='<s:text name="pollen.common.chartType-pie3d"/>' alt="2"/>
    </sj:a>
    <sj:a id='displayChart3' href="#" onclick="return displayCharts(3);">
      <img src="<s:url value='/img/rep3.png'/>"
           title='<s:text name="pollen.common.chartType-ring"/>' alt="3"/>
    </sj:a>
  </div>

  <div class="displayTypeDiv">
    <s:if test="groupPoll">
      <s:text name="pollen.common.results"/>
      <s:if test="byGroup">
        <s:a namespace="/poll" action="results/%{poll.pollId}">
          <s:param name="byGroup" value="false"/>
          <s:text name="pollen.common.normal"/>
        </s:a>
        - <s:text name="pollen.common.group"/>
      </s:if>
      <s:else>
        <s:text name="pollen.common.normal"/> -
        <s:a namespace="/poll" action="results/%{poll.pollId}">
          <s:text name="pollen.common.group"/>
        </s:a>
      </s:else>
    </s:if>
  </div>

  <sj:div id='chartContainer'>
    <img id='chart_normal'/>
  </sj:div>

  <!-- Diagramme par choix -->
  <s:if test="choicesResults != null">
    <div id="resultChart">
      <div>
        <s:iterator value="choicesResultNames" var="choicesResultName"
                    status="status">
          <img id='chart_<s:property value="#status.index"/>'
               alt="<s:property/>"
               title="<s:property/>"
               src="<s:property value='%{getChoicesResultCharUrl(400,300, #choicesResultName)}'/>">
        </s:iterator>
      </div>
    </div>
  </s:if>
</div>
<!-- Classement -->
<%--<t:remove>--%>
<%--<div id="resultList">--%>
<%--<ol>--%>
<%--<s:iterator value="ranking" var="result">--%>
<%--<li>--%>
<%--<s:if test="dateType">--%>
<%--<s:property value="%{getResultNameAsDate(#result.name)}"/>--%>
<%--&lt;%&ndash;<t:output value="resultNameAsDate" format="dateFormat"/>&ndash;%&gt;--%>
<%--</s:if>--%>
<%--<s:else>--%>
<%--<s:property value="name"/>--%>
<%--</s:else>--%>
<%--(<s:property value="%{getTrimValue(#result)}"/>)--%>
<%--</li>--%>
<%--</s:iterator>--%>
<%--</ol>--%>
<%--</div>--%>
<%--</t:remove>--%>

