/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.util.StringUtil;

public class Edit
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected UserAccount user;
    protected String newPassword;
    protected String newPassword2;

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public UserAccount getUser() {
        if (this.user == null) {
            this.user = this.getUserService().getNewUser();
        }
        return this.user;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPassword2() {
        return this.newPassword2;
    }

    public void setNewPassword2(String newPassword2) {
        this.newPassword2 = newPassword2;
    }

    public String input() throws Exception {
        UserAccount userAccount = this.getPollenUserAccount();
        this.user = (UserAccount)this.getUserService().getEntityById(UserAccount.class, userAccount.getTopiaId());
        return "input";
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.user.getLogin())) {
            this.addFieldError("user.login", this._("pollen.error.login.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.user.getPassword())) {
            this.addFieldError("user.password", this._("pollen.error.password.required", new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getNewPassword()) && ObjectUtils.notEqual((Object)this.getNewPassword(), (Object)this.getNewPassword2())) {
            this.addFieldError("newPassword", this._("pollen.error.passwords.not.equals", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.user.getEmail())) {
            this.addFieldError("user.email", this._("pollen.error.email.required", new Object[0]));
        } else if (!StringUtil.isEmail((String)this.user.getEmail())) {
            this.addFieldError("user.email", this._("pollen.error.email.invalid", new Object[0]));
        }
    }

    public String execute() throws Exception {
        this.user.setAdministrator(this.getPollenUserAccount().isAdministrator());
        String result = "input";
        try {
            UserAccount updatedUser = this.getUserService().updateUser(this.user, this.newPassword, false);
            this.getPollenSession().setUserAccount(updatedUser);
            result = "success";
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("user.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        catch (UserInvalidPasswordException e) {
            this.addFieldError("user.password", this._("pollen.error.user.invalid.password", new Object[0]));
        }
        this.user.setPassword(null);
        this.newPassword2 = null;
        this.newPassword = null;
        return result;
    }
}

