/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.pollen.bean.PollResult;
import org.chorem.pollen.bean.PollResultList;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.services.exceptions.PollAccountNotFound;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.poll.AbstractPollUriIdAction;
import org.chorem.pollen.ui.actions.poll.AbstractVoteAction;

public abstract class AbstractVoteAction
extends AbstractPollUriIdAction
implements ParameterAware,
ServletRequestAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractVoteAction.class);
    public static final String PREPARE_VOTE_PAGE = "prepareVotePage";
    private Poll poll;
    private boolean feedFileExisting;
    private boolean creatorUser;
    private PollAccount pollAccount;
    private boolean voteAllowed;
    private boolean resultAllowed;
    private List<Vote> votes;
    private Vote vote;
    private String commentAuthor;
    private List<PollResult> results;
    private List<Comment> comments;
    private Map<String, String[]> parameters;
    private SecurityService.AccountIdRole accountIdRole;
    private transient HttpServletRequest request;

    public abstract boolean isModerate();

    public PageSkin getSkin() {
        return PageSkin.VOTE;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public PollAccount getPollAccount() {
        return this.pollAccount;
    }

    public List<Vote> getVotes() {
        return this.votes;
    }

    public Vote getVote() {
        return this.vote;
    }

    public List<PollResult> getResults() {
        return this.results;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public String getCreatorName() {
        return this.poll.getCreator().getVotingId();
    }

    public String getVoteSizeMessage() {
        return this._("pollen.common.voteNbVotes", new Object[]{this.getPoll().sizeVote()});
    }

    public String getCommentAuthor() {
        if (this.commentAuthor == null) {
            UserAccount user = this.getPollenUserAccount();
            this.commentAuthor = user == null ? this.getPollAccount().getVotingId() : user.getDisplayName();
        }
        return this.commentAuthor;
    }

    public String getSummaryUrl() {
        PollUrl url = this.getPollUrlService().getPollSummaryUrl(this.poll);
        url.getPollUri().setAccountId(this.getAccountId());
        return url.getUrl();
    }

    public String getResultUrl() {
        PollUrl url = this.getPollUrlService().getPollResultUrl(this.poll);
        url.getPollUri().setAccountId(this.getAccountId());
        this.getSecurityService().removeAccountIdWhenConnected(url, this.getPollenUserAccount());
        return url.getUrl();
    }

    public String getVoteMessages() {
        return this._("pollen.common.voteNbVotes", new Object[]{this.poll.sizeVote()});
    }

    public boolean isFeedFileExisting() {
        return this.feedFileExisting;
    }

    public boolean isCreatorOrAdmin() {
        return this.creatorUser || this.isUserAdmin();
    }

    public boolean isAccountFieldDisplayed() {
        return !this.poll.isAnonymous() || this.isRestrictedPoll() || this.isGroupPoll();
    }

    public boolean isPollChoiceOrVoteStarted() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.isAddChoiceStarted(now) || this.poll.isStarted(now);
    }

    public boolean isAnonymousVote() {
        return this.poll.isAnonymous();
    }

    public boolean isPollChoiceRunning() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.isAddChoiceRunning(now);
    }

    public boolean isPollStarted() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.getBeginDate() == null || this.poll.getBeginDate().before(now);
    }

    public boolean isPollFinished() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.getEndDate() != null && this.poll.getEndDate().before(now);
    }

    public boolean isDescNull(Choice choice) {
        return StringUtils.isEmpty((CharSequence)choice.getDescription());
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public boolean isNormalVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.NORMAL;
    }

    public boolean isPercentageVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.PERCENTAGE;
    }

    public boolean isCondorcetVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.CONDORCET;
    }

    public boolean isNumberVoteCounting() {
        return this.poll.getVoteCountingType() == VoteCountingType.NUMBER;
    }

    public boolean isVoteAllowed() {
        return this.voteAllowed;
    }

    public boolean isResultAllowed() {
        return this.resultAllowed;
    }

    public boolean isModifyVoteAllowed(Vote vote) {
        return this.getSecurityService().isCanModifyVote(this.getPoll(), vote.getTopiaId(), this.getAccountId(), this.getPollenUserAccount());
    }

    public boolean isDeleteCommentAllowed(Comment comment) {
        return this.getSecurityService().isCanDeleteComment(comment, this.getUriId().getAccountId(), this.accountIdRole, this.getPollenUserAccount());
    }

    public boolean isDeleteVoteAllowed(Vote vote) {
        return this.getSecurityService().isCanDeleteVote(this.getPoll(), vote.getTopiaId(), this.getUriId().getAccountId(), this.accountIdRole, this.getPollenUserAccount());
    }

    public String getResultValue(Choice choice) {
        String val = this.getPollResultsService().getResultValue(choice, (Collection)this.results);
        return val;
    }

    public boolean isChoiceInVote(VoteToChoice choice) {
        boolean result = false;
        if (choice != null) {
            switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[this.poll.getVoteCountingType().ordinal()]) {
                case 1: {
                    result = choice.getVoteValue() > 0;
                    break;
                }
                case 2: {
                    result = true;
                    break;
                }
                case 3: {
                    result = choice.getVoteValue() < 100;
                    break;
                }
                case 4: {
                    result = choice.getVoteValue() >= 0;
                }
            }
        }
        return result;
    }

    public Date getChoiceAsDate(Choice choice) {
        return new Date(Long.valueOf(choice.getName()));
    }

    public void setCommentAuthor(String commentAuthor) {
        this.commentAuthor = commentAuthor;
    }

    public String prepareVotePage() throws Exception {
        boolean moderate = this.isModerate();
        this.loadPoll();
        this.loadPollAccount();
        this.votes = this.getVoteService().getAllVotes(this.poll);
        this.accountIdRole = PollenUIUtils.getAccountIdRole((ServletRequest)this.request);
        if (moderate) {
            this.voteAllowed = false;
        } else {
            String accountId = this.getAccountId();
            if (this.accountIdRole == SecurityService.AccountIdRole.CREATOR) {
                accountId = null;
            }
            this.voteAllowed = this.getSecurityService().isCanVote(this.poll, accountId, this.accountIdRole);
        }
        this.resultAllowed = this.getSecurityService().isCanAccessResult(this.poll, this.getAccountId(), this.accountIdRole, this.getPollenUserAccount());
        if (this.voteAllowed) {
            this.vote = this.getVoteService().getVoteEditable(this.poll, this.pollAccount);
        }
        PollResultList pollResultList = this.getPollResultsService().getResults(this.poll);
        this.results = pollResultList.getPollResults();
        if (log.isDebugEnabled()) {
            for (PollResult res : this.results) {
                log.debug((Object)(res.getName() + ": " + res.getValue() + ", (voteCounting=" + res.getVoteCountingType() + ", byGroup=" + res.isByGroup() + ")"));
            }
        }
        this.comments = this.getPollCommentService().getAllComments(this.poll.getPollId());
        this.feedFileExisting = this.getPollFeedService().isFeedExists(this.poll);
        this.creatorUser = this.getSecurityService().isPollCreator(this.poll, this.getAccountId(), this.getPollenUserAccount());
        if (log.isInfoEnabled()) {
            Date now = this.serviceContext.getCurrentTime();
            log.info((Object)("pollChoiceOrVoteStarted = " + this.isPollChoiceOrVoteStarted()));
            log.info((Object)("pollChoiceRunning       = " + this.isPollChoiceRunning()));
            log.info((Object)("pollRunning             = " + this.poll.isRunning(now)));
            log.info((Object)("accountFieldDisplayed   = " + this.isAccountFieldDisplayed()));
            log.info((Object)("creatorUser             = " + this.creatorUser));
        }
        return "input";
    }

    public String escapeLineBreak(String text) {
        return text;
    }

    protected void loadPollAccount() throws PollAccountNotFound {
        this.pollAccount = this.getPollService().getPollAccountEditable(this.getAccountId(), this.getPollenUserAccount(), this.poll);
    }

    protected void loadPoll() throws PollNotFoundException {
        this.preparePollUri(this.parameters);
        String pollId = this.getPollId();
        if (StringUtils.isNotEmpty((CharSequence)pollId)) {
            this.poll = this.getPollService().getExistingPollByPollId(pollId);
        }
        Preconditions.checkNotNull((Object)this.poll, (Object)("Can't load poll with id = [" + pollId + "]"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Poll TopiaId: " + this.poll.getTopiaId()));
        }
    }
}

