/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class GetUsers
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] users;

    public Map<String, Object>[] getUsers() {
        return this.users;
    }

    public Integer getRows() {
        return this.pager.getPageSize();
    }

    public Integer getPage() {
        return this.pager.getPageIndex();
    }

    public Integer getTotal() {
        return this.pager.getPagesNumber();
    }

    public Integer getRecords() {
        return this.pager.getRecords();
    }

    public String execute() throws Exception {
        List allUsers = this.getUserService().getUsers(this.pager);
        UserAccount userAccount = this.getPollenUserAccount();
        this.users = new Map[allUsers.size()];
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(UserAccount.class);
        int index = 0;
        for (UserAccount user : allUsers) {
            Map map = binder.obtainProperties((Object)user, new String[0]);
            map.put("id", user.getTopiaId());
            Set functions = this.getUserFunctions(userAccount, user);
            map.put("functions", functions);
            this.users[index++] = map;
        }
        return "success";
    }

    protected Set<String> getUserFunctions(UserAccount connectedUser, UserAccount user) {
        HashSet result = Sets.newHashSet();
        result.add("edit");
        if (!user.equals(connectedUser)) {
            result.add("delete");
        }
        return result;
    }
}

