/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: PollVoteAccessRequired.java 3516 2012-06-18 16:19:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/security/PollVoteAccessRequired.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.security;

import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.PollenUIUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import static org.nuiton.i18n.I18n.n_;

/**
 * Check that a user can vote.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class PollVoteAccessRequired extends AbstractPollenAuthorization {

    protected final AdminUserRequired adminFilter;

    public PollVoteAccessRequired() {
        adminFilter = new AdminUserRequired();
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request,
                                      ServletResponse response,
                                      Object mappedValue) {

        PollenServiceContext serviceContext = getServiceContext(request);

        PollUri pollUri = getPollUri(request);

        SecurityService securityService =
                serviceContext.newService(SecurityService.class);

        // get sane poll
        final Poll poll = getPollIdSane(pollUri, serviceContext, request);

        boolean isAccessAllowed = poll != null;

        SecurityService.AccountIdRole accountIdRole = null;

        if (isAccessAllowed) {

            // pollId is sane (poll exists from it)

            // test if user is admin
            boolean isAdmin = adminFilter.isAccessAllowed(request,
                                                          response,
                                                          mappedValue);

            boolean withAccountId = pollUri.isAccountIdNotBlank();

            if (withAccountId) {

                // there is a account id, must validate it
                accountIdRole = securityService.getAccountIdRole(
                        poll, pollUri.getAccountId());

                if (accountIdRole == SecurityService.AccountIdRole.UNDEFINED) {

                    // bad account Id
                    isAccessAllowed = false;
                    registerError(request,
                                  n_("pollen.security.error.bad.accountId"));
                }
            }

            if (isAdmin) {

                // admin user acts as a poll creator
                accountIdRole = SecurityService.AccountIdRole.CREATOR;
            }
        }

        if (isAccessAllowed) {

            // pollId is sane
            // accountId is sane

            // check now poll votes can be displayed

            String errorMessage = securityService.isCanAccessVote(
                    poll, pollUri.getAccountId(), accountIdRole);

            if (errorMessage != null) {

                // can not vote
                isAccessAllowed = false;
                registerError(request, errorMessage);
            }
        }

        if (isAccessAllowed) {

            // store accountIdRole in request
            PollenUIUtils.setAccountIdRole(request, accountIdRole);
        }

        return isAccessAllowed;
    }

}