/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: LostPassword.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/LostPassword.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.util.StringUtil;

/**
 * Created: 13/04/12
 *
 * @author fdesbois <desbois@codelutin.com>
 * @since 1.3
 */
public class LostPassword extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    private String email;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String execute() throws Exception {

        if (StringUtils.isBlank(email) || !StringUtil.isEmail(email)) {
            addFlashError(_("pollen.error.lostPassword.email"));

        } else {

            try {
                getUserService().lostPassword(email);

                addFlashMessage(_("pollen.information.lostPassword.success"));

            } catch (UserNotFoundException e) {
                addFlashError(_("pollen.error.lostPassword.user"));
            }
        }
        return SUCCESS;
    }
}
