/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: SummaryPoll.java 3516 2012-06-18 16:19:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/SummaryPoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.actions.PageSkin;

import javax.servlet.http.HttpServletRequest;

/**
 * Action to display summary of a poll for his creator (or an admin).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class SummaryPoll extends AbstractPollUriIdAction implements ServletRequestAware {

    private static final long serialVersionUID = 1L;

    /**
     * Loaded poll.
     *
     * @since 1.4
     */
    private Poll poll;

    /**
     * The accountId role on this page.
     *
     * @since 1.4
     */
    private SecurityService.AccountIdRole accountIdRole;

    /**
     * The incoming request (some stuff are store in it from security filters).
     *
     * @since 1.4
     */
    private transient HttpServletRequest request;

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    public Poll getPoll() {
        return poll;
    }

    public String getVoteUrl() {
        PollUrl url = getPollUrlService().getPollVoteUrl(poll);
        if (poll.getPollType() == PollType.FREE) {

            // can removed accountId only for free poll
            //FIXME Should found out in ohter case the accountId (if exists for the connected id) if no accountId is given
            getSecurityService().removeAccountIdWhenConnected(url, getPollenUserAccount());
        }
        return url.getUrl();
    }

    public String getModerateUrl() {
        PollUrl url = getPollUrlService().getPollModerateUrl(poll);
        getSecurityService().removeAccountIdWhenConnected(url, getPollenUserAccount());
        return url.getUrl();
    }

    public String getEditUrl() {
        PollUrl url = getPollUrlService().getPollEditUrl(poll);
        getSecurityService().removeAccountIdWhenConnected(url, getPollenUserAccount());
        return url.getUrl();
    }

    public String getCloneUrl() {
        PollUrl url = getPollUrlService().getPollCloneUrl(poll);
        getSecurityService().removeAccountIdWhenConnected(url, getPollenUserAccount());
        return url.getUrl();
    }

    public String getExportUrl() {
        PollUrl url = getPollUrlService().getPollExportUrl(poll);
        getSecurityService().removeAccountIdWhenConnected(url, getPollenUserAccount());
        return url.getUrl();
    }

    public String getResultUrl() {
        PollUrl url = getPollUrlService().getPollResultUrl(poll);
        getSecurityService().removeAccountIdWhenConnected(url, getPollenUserAccount());
        return url.getUrl();
    }

    public boolean isCanClose() {
        return getSecurityService().isCanClosePoll(poll, accountIdRole);
    }

    public boolean isCanShowResult() {
        String errorMessage = getSecurityService().isCanAccessResult(
                poll, accountIdRole);
        return errorMessage == null;
    }

    public boolean isCanVote() {
        String accountId = getAccountId();
        if (accountIdRole == SecurityService.AccountIdRole.CREATOR) {
            accountId = null;
        }
        return getSecurityService().isCanVote(poll,
                                              accountId,
                                              accountIdRole);
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(getUriId());

        String pollId = getUriId().getPollId();

        poll = getPollService().getExistingPollByPollId(pollId);

        accountIdRole = PollenUIUtils.getAccountIdRole(request);

        return SUCCESS;
    }
}
