/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: ClonePoll.java 3501 2012-06-17 13:23:21Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/ClonePoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import org.chorem.pollen.business.persistence.Poll;

/**
 * Clones a poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class ClonePoll extends AbstractPollForm {

    private static final long serialVersionUID = 1L;

    @Override
    public boolean isClone() {
        return true;
    }

    @Override
    public boolean isEdit() {
        return false;
    }

    @Override
    protected Poll savePoll(Poll poll) {
        poll = getPollService().createPoll(poll);
        addFlashMessage(_("pollen.information.poll.created", poll.getTitle()));
        return poll;
    }

}
