/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: GetUser.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetUser.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.util.beans.Binder;

import java.util.Map;

/**
 * Get user datas.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetUser extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    private String userId;

    private transient Map<String, Object> user;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Map<String, Object> getUser() {
        return user;
    }

    @Override
    public String execute() throws Exception {

        UserService userService = newService(UserService.class);

        UserAccount userAccount = userService.getEntityById(UserAccount.class, userId);

        Binder<UserAccount, UserAccount> binder =
                PollenBinderHelper.getSimpleTopiaBinder(UserAccount.class);
        user = binder.obtainProperties(
                userAccount
        );
        user.put("id", userAccount.getTopiaId());

        return SUCCESS;
    }
}
