/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.admin;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class ManageUsers
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected String action;
    protected UserAccount user;

    public UserAccount getUser() {
        if (this.user == null) {
            UserService service = (UserService)this.newService(UserService.class);
            this.user = service.getNewUser();
        }
        return this.user;
    }

    public UserAccount getCreateUser() {
        return this.getUser();
    }

    public UserAccount getEditUser() {
        return this.getUser();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String create() throws Exception {
        Preconditions.checkNotNull((Object)this.user);
        String result = "input";
        try {
            ((UserService)this.newService(UserService.class)).createUser(this.user, true);
            this.addFlashMessage(this._("pollen.information.user.created", new Object[]{this.user.getDisplayName()}));
            this.user = null;
            this.action = null;
            result = "success";
        }
        catch (UserLoginAlreadyUsedException e) {
            this.addFieldError("createUser.login", this._("pollen.error.user.login.already.used", new Object[0]));
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("createUser.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        return result;
    }

    public String edit() throws Exception {
        Preconditions.checkNotNull((Object)this.user);
        UserService service = (UserService)this.newService(UserService.class);
        String result = "input";
        try {
            service.updateUser(this.user, null, true);
            this.getTransaction().commitTransaction();
            this.addFlashMessage(this._("pollen.information.user.updated", new Object[]{this.user.getDisplayName()}));
            this.user = null;
            this.action = null;
            result = "success";
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("editUser.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        catch (UserInvalidPasswordException e) {
            this.addFieldError("editUser.password", this._("pollen.error.user.invalid.password", new Object[0]));
        }
        return result;
    }
}

