/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.ui.actions.poll.AbstractVoteAction;

public class VoteForPoll
extends AbstractVoteAction
implements Preparable {
    private static final Log log = LogFactory.getLog(VoteForPoll.class);
    private static final long serialVersionUID = 1L;

    public void prepare() throws Exception {
        this.prepareVotePage();
    }

    public void validate() {
        Vote vote = this.getVote();
        Preconditions.checkNotNull((Object)vote);
        PollAccount pollAccount = this.getVote().getPollAccount();
        Preconditions.checkNotNull((Object)pollAccount);
        Poll poll = this.getPoll();
        if (!vote.isAnonymous()) {
            String name = pollAccount.getVotingId();
            if (StringUtils.isBlank((CharSequence)name)) {
                this.addFieldError("pollAccount.votingId", this._("pollen.error.pollAccount.votingId.required", new Object[0]));
            }
            if (pollAccount.getTopiaId() == null && this.getVoteService().hasAlreadyVoted(name, poll)) {
                this.addFieldError("pollAccount.votingId", this._("pollen.error.user.alreadyVoted", new Object[0]));
            }
        }
        int nbVotes = 0;
        int totalValues = 0;
        for (VoteToChoice voteToChoice : vote.getChoiceVoteToChoice()) {
            Integer value = voteToChoice.getVoteValue();
            if (value == null || value == 0) continue;
            ++nbVotes;
            totalValues += value.intValue();
        }
        int maxChoice = this.getPoll().getMaxChoiceNb();
        if (maxChoice != 0 && nbVotes > maxChoice) {
            this.addFieldError("vote.choices", this._("pollen.error.vote.maxChoiceNb", new Object[]{maxChoice}));
        }
        if (this.isPercentageVoteCounting() && totalValues != 100) {
            this.addFieldError("vote.choices", this._("pollen.error.vote.percentage", new Object[0]));
        }
    }

    public String execute() throws Exception {
        if (this.getVote().getTopiaId() != null) {
            this.getVoteService().updateVote(this.getVote());
        } else {
            Vote voteCreated = this.getVoteService().createVote(this.getVote());
            this.getPollService().addVoteToPoll(this.getPoll(), voteCreated);
        }
        this.clearFlashMessages();
        if (PollType.FREE == this.getPoll().getPollType() && !this.isUserLoggued()) {
            String pollId = this.getPoll().getPollId();
            String accountId = this.getPollAccount().getAccountId();
            PollUri pollUri = PollUri.newPollUri((String)pollId, (String)accountId);
            String updateUrl = this.getVoteService().getUpdateVoteUrl(pollUri);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UpdateURL for poll '%s' and account '%s' = %s", pollId, accountId, updateUrl));
            }
            this.addFlashMessage(this._("pollen.information.vote.createdWithUpdateUrl", new Object[]{updateUrl}));
        } else {
            this.addFlashMessage(this._("pollen.information.vote.created", new Object[0]));
        }
        return "success";
    }
}

