/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.bean.ChoiceHelper;
import org.chorem.pollen.bean.PollDateChoice;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceImpl;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListImpl;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountImpl;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListImpl;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.services.impl.PreventRuleService;
import org.chorem.pollen.ui.actions.FileUploadAware;
import org.chorem.pollen.ui.actions.poll.AbstractPollForm;
import org.chorem.pollen.ui.actions.poll.SavePoll;
import org.chorem.pollen.ui.converters.DateConverter;
import org.nuiton.util.StringUtil;

public class SavePoll
extends AbstractPollForm
implements Preparable,
ParameterAware,
FileUploadAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SavePoll.class);
    private static final Pattern TEXT_CHOICE_NAME_PATTERN = Pattern.compile("textChoice_(\\d+)\\.name");
    private static final Pattern DATE_CHOICE_NAME_PATTERN = Pattern.compile("dateChoice_(\\d+)\\.name");
    private static final Pattern IMAGE_CHOICE_NAME_PATTERN = Pattern.compile("imageChoice_(\\d+)\\.name");
    protected boolean informationsError;
    private boolean optionsError;
    protected final Map<String, String[]> parameters = Maps.newTreeMap();
    private Map<Integer, Choice> choices;
    private Map<Integer, VotingList> votingLists;

    public void prepare() throws Exception {
        String userId;
        this.prepareFormPage();
        String pollUid = this.getNonEmptyParameterValue("poll.pollId");
        UserAccount userAccount = this.getPollenUserAccount();
        if (userAccount == null && (userId = this.getNonEmptyParameterValue("userId")) != null) {
            userAccount = (UserAccount)this.getPollService().getEntityById(UserAccount.class, userId);
        }
        this.poll = this.getPollService().getPollEditable(pollUid, userAccount, false);
        if (!this.isVoteStarted()) {
            String choiceTypeParam = this.getNonEmptyParameterValue("poll.choiceType");
            ChoiceType pollChoiceType = ChoiceType.valueOf((String)choiceTypeParam);
            this.poll.setChoiceType(pollChoiceType);
            switch (1.$SwitchMap$org$chorem$pollen$common$ChoiceType[pollChoiceType.ordinal()]) {
                case 1: {
                    this.choices = this.buildTextChoices();
                    break;
                }
                case 2: {
                    this.choices = this.buildDateChoices();
                    break;
                }
                case 3: {
                    this.choices = this.buildImageChoices();
                }
            }
            String pollTypeParam = this.getNonEmptyParameterValue("poll.pollType");
            PollType pollType = pollTypeParam == null ? this.poll.getPollType() : PollType.valueOf((String)pollTypeParam);
            switch (1.$SwitchMap$org$chorem$pollen$common$PollType[pollType.ordinal()]) {
                case 1: {
                    this.votingLists = Maps.newTreeMap();
                    break;
                }
                case 2: {
                    this.votingLists = this.buildVotingLists(pollType);
                    break;
                }
                case 3: {
                    this.votingLists = this.buildVotingLists(pollType);
                }
            }
        }
    }

    public String input() {
        Collection<Object> pollChoices = this.isVoteStarted() ? this.poll.getChoice() : this.choices.values();
        Collection<Object> pollVotingLists = this.isVoteStarted() ? this.poll.getVotingList() : this.votingLists.values();
        this.loadChoicesAndvotingLists(this.poll, (Collection)pollChoices, (Collection)pollVotingLists, true);
        return "input";
    }

    public void validate() {
        this.validateInformations();
        this.validateOptions();
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        PreventRule rule;
        if (!this.isVoteStarted()) {
            this.poll.clearChoice();
            this.poll.clearVotingList();
            Map orderedChoices = this.choices;
            for (Integer index : orderedChoices.keySet()) {
                Choice choice = (Choice)orderedChoices.get(index);
                this.poll.addChoice(choice);
            }
            if (!this.isFreePoll()) {
                for (Integer index : this.votingLists.keySet()) {
                    VotingList votingList = (VotingList)this.votingLists.get(index);
                    this.poll.addVotingList(votingList);
                }
            }
        }
        if (!this.isLimitChoice()) {
            this.poll.setMaxChoiceNb(0);
        }
        this.poll.clearPreventRule();
        PreventRuleService preventRuleService = (PreventRuleService)this.newService(PreventRuleService.class);
        if (this.isNotification()) {
            rule = preventRuleService.createAddVotePreventRule();
            this.poll.addPreventRule(rule);
        }
        if (this.isReminder()) {
            rule = preventRuleService.createRemindPreventRule(this.getReminderHourCountdown());
            this.poll.addPreventRule(rule);
        }
        if (this.isEdit()) {
            this.getPollService().updatePoll(this.poll);
            this.addFlashMessage(this._("pollen.information.poll.updated", new Object[0]));
        } else {
            this.getPollService().createPoll(this.poll);
            this.addFlashMessage(this._("pollen.information.poll.created", new Object[0]));
        }
        this.getPollenSession().clearDynamicData();
        return "success";
    }

    public void addFile(int index, File file) {
        this.parameters.put("imageChoice_" + index + ".location", new String[]{file.getAbsolutePath()});
    }

    public void addFileContentType(int index, String contentType) {
    }

    public void addFileName(int index, String fileName) {
        this.parameters.put("imageChoice_" + index + ".name", new String[]{fileName});
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters.putAll(parameters);
    }

    public boolean isInformationsError() {
        return this.informationsError;
    }

    public boolean isOptionsError() {
        return this.optionsError;
    }

    public int getSelectedTab() {
        int result = this.isInformationsError() ? 0 : (this.isOptionsError() ? 1 : 0);
        return result;
    }

    protected void validateInformations() {
        if (StringUtils.isBlank((CharSequence)this.poll.getTitle())) {
            this.addInformationsError("poll.title", this._("pollen.error.poll.required.title", new Object[0]));
        }
        if (!this.isVoteStarted()) {
            if (MapUtils.isEmpty((Map)this.choices)) {
                this.addInformationsError("poll.choices", this._("pollen.error.poll.required.one.choice", new Object[0]));
            } else {
                HashSet choiceValues;
                ChoiceType choiceType = this.poll.getChoiceType();
                int inputChoicesSize = this.choices.size();
                if (inputChoicesSize > (choiceValues = Sets.newHashSet((Iterable)ChoiceHelper.toValues(this.choices.values(), (ChoiceType)choiceType))).size()) {
                    this.addInformationsError("poll.choices", this._("pollen.error.poll.detected.duplicate.choice.name", new Object[0]));
                }
            }
        }
    }

    protected void validateOptions() {
        String creatorEmail;
        if (!this.isVoteStarted() && !this.isFreePoll()) {
            HashSet groups = Sets.newHashSet();
            HashSet voters = Sets.newHashSet();
            HashSet emails = Sets.newHashSet();
            for (Map.Entry entry : this.votingLists.entrySet()) {
                this.validateVotingList(((Integer)entry.getKey()).intValue(), (VotingList)entry.getValue(), (Set)groups, (Set)voters, (Set)emails);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(creatorEmail = this.poll.getCreator().getEmail())) && !StringUtil.isEmail((String)creatorEmail)) {
            this.addOptionsError("poll.creator.email", this._("pollen.error.email.invalid", new Object[0]));
        }
        if (this.validateEndDate(this.poll.getBeginChoiceDate(), this.poll.getEndChoiceDate())) {
            this.addOptionsError("poll.endChoiceDate", this._("pollen.error.poll.endChoiceDate.before.beginChoiceDate", new Object[0]));
        }
        if (this.validateEndDate(this.poll.getBeginDate(), this.poll.getEndDate())) {
            this.addOptionsError("poll.endDate", this._("pollen.error.poll.endDate.before.beginDate", new Object[0]));
        }
        if (this.validateEndDate(this.poll.getEndChoiceDate(), this.poll.getEndDate())) {
            this.addOptionsError("poll.endChoiceDate", this._("pollen.error.poll.endChoiceDate.after.endDate", new Object[0]));
        }
    }

    protected void validateVotingList(int votingListNumber, VotingList votingList, Set<String> groups, Set<String> voters, Set<String> emails) {
        List personToLists;
        PollType votingListType = this.poll.getPollType();
        String fieldNamePrefix = "votingList" + votingListType + "_" + votingListNumber;
        if (this.isGroupPoll()) {
            String votingListName = votingList.getName();
            if (StringUtils.isEmpty((CharSequence)votingListName)) {
                this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.required.votingList.name", new Object[0]));
            } else {
                boolean add = groups.add(votingListName);
                if (!add) {
                    this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.votingList.name.doublon", new Object[0]));
                }
            }
            if (votingList.getWeight() == 0.0) {
                this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.votingList.weight.not.valid", new Object[0]));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(personToLists = votingList.getPollAccountPersonToList()))) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.required.one.personToList", new Object[0]));
        } else {
            for (int i = 0; i < personToLists.size(); ++i) {
                this.validatePersonList(i, fieldNamePrefix, (PersonToList)personToLists.get(i), voters, emails);
            }
        }
    }

    protected void validatePersonList(int personToListNumber, String votingListFieldNamePrefix, PersonToList personToList, Set<String> voters, Set<String> emails) {
        String email;
        String fieldNamePrefix = votingListFieldNamePrefix + "PersonToList_" + personToListNumber;
        PollAccount pollAccount = personToList.getPollAccount();
        String votingId = pollAccount.getVotingId();
        boolean add = voters.add(votingId);
        if (!add) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.personToList.votingId.doublon", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)(email = pollAccount.getEmail()))) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.email.required", new Object[0]));
        } else {
            boolean validEmail = StringUtil.isEmail((String)email);
            if (!validEmail) {
                this.addOptionsError(fieldNamePrefix, this._("pollen.error.email.invalid", new Object[0]));
            } else {
                boolean add2 = emails.add(email);
                if (!add2) {
                    this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.personToList.email.doublon", new Object[0]));
                }
            }
        }
        if (personToList.getWeight() == 0.0) {
            this.addOptionsError(fieldNamePrefix, this._("pollen.error.poll.personToList.weight.not.valid", new Object[0]));
        }
    }

    protected boolean validateEndDate(Date begin, Date end) {
        return begin != null && end != null && end.before(begin);
    }

    public void addFieldError(String fieldName, String errorMessage) {
        super.addFieldError(fieldName, errorMessage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("VALIDATION [" + fieldName + "] : " + errorMessage));
        }
    }

    protected void addInformationsError(String fieldName, String errorMessage) {
        this.addFieldError(fieldName, errorMessage);
        this.informationsError = true;
    }

    protected void addOptionsError(String fieldName, String errorMessage) {
        this.addFieldError(fieldName, errorMessage);
        this.optionsError = true;
    }

    protected Map<Integer, Choice> buildTextChoices() {
        Map<Integer, Choice> result = Maps.newTreeMap();
        int maxNumber = 0;
        for (String paramName : this.parameters.keySet()) {
            String paramValue;
            Matcher matcher = TEXT_CHOICE_NAME_PATTERN.matcher(paramName);
            if (!matcher.matches() || (paramValue = this.getNonEmptyParameterValue(paramName)) == null) continue;
            Integer choiceNumber = Integer.valueOf(matcher.group(1));
            if (choiceNumber > maxNumber) {
                maxNumber = choiceNumber;
            }
            ChoiceImpl choice = new ChoiceImpl();
            this.createChoice((Choice)choice, "textChoice_" + choiceNumber, paramValue);
            result.put(choiceNumber, (Choice)choice);
        }
        result = this.reindexMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbTextChoices (from request) = " + size));
        }
        this.logChoice(result);
        return result;
    }

    protected Map<Integer, Choice> buildDateChoices() {
        Map<Integer, Choice> result = Maps.newTreeMap();
        int maxNumber = 0;
        for (String paramName : this.parameters.keySet()) {
            String paramValue;
            Matcher matcher = DATE_CHOICE_NAME_PATTERN.matcher(paramName);
            if (!matcher.matches() || (paramValue = this.getNonEmptyParameterValue(paramName)) == null) continue;
            Integer choiceNumber = Integer.valueOf(matcher.group(1));
            if (choiceNumber > maxNumber) {
                maxNumber = choiceNumber;
            }
            PollDateChoice choice = new PollDateChoice();
            this.createDateChoice(choice, "dateChoice_" + choiceNumber, paramValue);
            result.put(choiceNumber, (Choice)choice);
        }
        result = this.reindexMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbDateChoices (from request)  = " + size));
        }
        this.logChoice(result);
        return result;
    }

    protected Map<Integer, Choice> buildImageChoices() {
        Map<Integer, Choice> result = Maps.newTreeMap();
        int maxNumber = 0;
        for (String paramName : this.parameters.keySet()) {
            String paramValue;
            Matcher matcher = IMAGE_CHOICE_NAME_PATTERN.matcher(paramName);
            if (!matcher.matches() || (paramValue = this.getNonEmptyParameterValue(paramName)) == null) continue;
            Integer choiceNumber = Integer.valueOf(matcher.group(1));
            if (choiceNumber > maxNumber) {
                maxNumber = choiceNumber;
            }
            PollImageChoice choice = new PollImageChoice();
            this.createImageChoice(choice, "imageChoice_" + choiceNumber, paramValue);
            result.put(choiceNumber, (Choice)choice);
        }
        result = this.reindexMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbImageChoices  (from request) = " + size));
        }
        this.logChoice(result);
        return result;
    }

    protected Map<Integer, VotingList> buildVotingLists(PollType pollType) {
        Map<Integer, VotingList> result = Maps.newTreeMap();
        int maxNumber = 0;
        String votingListPrefix = "votingList" + pollType.name();
        Set votingListParameterNames = Sets.filter(this.parameters.keySet(), (Predicate)new StringStartWithPredicate(votingListPrefix));
        Pattern votingListPattern = Pattern.compile("(" + votingListPrefix + ")_(\\d+)\\.name");
        for (String paramName : votingListParameterNames) {
            Matcher matcher = votingListPattern.matcher(paramName);
            if (!matcher.matches()) continue;
            int votingListNumber = Integer.valueOf(matcher.group(2));
            votingListPrefix = votingListPrefix + "_" + votingListNumber;
            this.buildVotingList(paramName, votingListPrefix, votingListNumber, result);
            maxNumber = Math.max(maxNumber, votingListNumber);
        }
        result = this.reindexMap((Map)result, maxNumber);
        int size = result.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("nbVotingList [" + pollType + "] (from request) = " + size));
        }
        for (Map.Entry entry : result.entrySet()) {
            Integer votingListNumber = (Integer)entry.getKey();
            VotingList votingList = (VotingList)entry.getValue();
            if (votingList.isPollAccountPersonToListEmpty()) continue;
            List personToList = votingList.getPollAccountPersonToList();
            TreeMap personToListMap = Maps.newTreeMap();
            int index = 0;
            for (PersonToList toList : personToList) {
                personToListMap.put(index++, toList);
            }
        }
        return result;
    }

    private double getDoubleValue(String parameterName) {
        double result;
        block3: {
            String parameterValue = this.getNonEmptyParameterValue(parameterName);
            result = 0.0;
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                try {
                    result = Double.valueOf(parameterValue);
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Bad double conversion from param [" + parameterName + "] : " + parameterValue));
                }
            }
        }
        return result;
    }

    private int buildVotingList(String votingListParameterName, String votingListPrefix, int votingListNumber, Map<Integer, VotingList> result) {
        String paramValue = this.getNonEmptyParameterValue(votingListParameterName);
        VotingListImpl votingList = new VotingListImpl();
        votingList.setName(paramValue);
        double weight = this.getDoubleValue(votingListPrefix + ".weight");
        votingList.setWeight(weight);
        String topiaId = this.getNonEmptyParameterValue(votingListPrefix + ".topiaId");
        votingList.setTopiaId(topiaId);
        result.put(votingListNumber, (VotingList)votingList);
        String personToListPrefix = votingListPrefix + "PersonToList_";
        Set votingListParameterNames = Sets.filter(this.parameters.keySet(), (Predicate)new StringStartWithPredicate(personToListPrefix));
        Pattern personToListNamePattern = Pattern.compile(personToListPrefix + "(\\d+)\\.votingId");
        Map personToLists = Maps.newTreeMap();
        int maxPersonToListNumber = 0;
        for (String personToListNameParameter : votingListParameterNames) {
            Matcher matcher = personToListNamePattern.matcher(personToListNameParameter);
            if (!matcher.matches()) continue;
            int personToListNumber = this.buildPersonToList(personToListPrefix, personToListNameParameter, matcher, votingListNumber, personToLists);
            maxPersonToListNumber = Math.max(maxPersonToListNumber, personToListNumber);
        }
        personToLists = this.reindexMap(personToLists, maxPersonToListNumber);
        for (PersonToList personToList : personToLists.values()) {
            votingList.addPollAccountPersonToList(personToList);
        }
        return votingListNumber;
    }

    private int buildPersonToList(String personToListPrefix, String paramName, Matcher personToListMatcher, int votingListNumber, Map<Integer, PersonToList> result) {
        String paramValue = this.getNonEmptyParameterValue(paramName);
        int personToListNumber = 0;
        if (paramValue != null) {
            personToListNumber = Integer.valueOf(personToListMatcher.group(1));
            PersonToListImpl personToList = new PersonToListImpl();
            PollAccountImpl account = new PollAccountImpl();
            personToList.setPollAccount((PollAccount)account);
            account.setVotingId(paramValue);
            String prefix = personToListPrefix + personToListNumber;
            double weight = this.getDoubleValue(prefix + ".weight");
            personToList.setWeight(weight);
            String topiaId = this.getNonEmptyParameterValue(prefix + ".topiaId");
            personToList.setTopiaId(topiaId);
            String email = this.getNonEmptyParameterValue(prefix + ".email");
            account.setEmail(email);
            String accountId = this.getNonEmptyParameterValue(prefix + ".accountId");
            account.setAccountId(accountId);
            result.put(personToListNumber, (PersonToList)personToList);
        }
        return personToListNumber;
    }

    private Choice createImageChoice(PollImageChoice choice, String prefix, String name) {
        this.createChoice((Choice)choice, prefix, name);
        String locationName = prefix + ".location";
        String location = this.getNonEmptyParameterValue(locationName);
        choice.setLocation(location);
        if (log.isInfoEnabled()) {
            log.info((Object)("image location [" + name + "] =" + location));
        }
        return choice;
    }

    private Choice createDateChoice(PollDateChoice choice, String prefix, String name) {
        this.createChoice((Choice)choice, prefix, name);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            Date date = DateConverter.convertFromString((String)name);
            if (date == null) {
                this.addInformationsError(prefix, this._("pollen.error.date.format", new Object[0]));
            }
            choice.setDate(date);
        }
        return choice;
    }

    private Choice createChoice(Choice choice, String prefix, String name) {
        String descriptionName = prefix + ".description";
        String topiaIdName = prefix + ".topiaId";
        String description = this.getNonEmptyParameterValue(descriptionName);
        String topiaId = this.getNonEmptyParameterValue(topiaIdName);
        choice.setName(name);
        choice.setDescription(description);
        choice.setTopiaId(topiaId);
        return choice;
    }

    private void logChoice(Map<Integer, Choice> result) {
        for (Map.Entry<Integer, Choice> e : result.entrySet()) {
            Integer choiceId = e.getKey();
            Choice choice = e.getValue();
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Choice [" + choiceId + "] = " + choice.getName() + " -- " + choice.getDescription()));
        }
    }

    protected <T> Map<Integer, T> reindexMap(Map<Integer, T> result, int maxNumber) {
        TreeMap result2;
        if (maxNumber != result.size() - 1) {
            ArrayList numbers = Lists.newArrayList(result.keySet());
            Collections.sort(numbers);
            result2 = Maps.newTreeMap();
            int i = 0;
            for (Integer number : numbers) {
                Object choice = result.get(number);
                result2.put(i++, choice);
            }
        } else {
            result2 = result;
        }
        return result2;
    }

    protected String getNonEmptyParameterValue(String paramName) {
        String paramValue;
        String[] paramValues = (String[])this.parameters.get(paramName);
        String result = null;
        if (paramValues != null && paramValues.length == 1 && StringUtils.isNotEmpty((CharSequence)(paramValue = paramValues[0]))) {
            result = paramValue;
        }
        return result;
    }
}

