/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: AddChoice.java 3372 2012-05-18 06:52:21Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/AddChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.collect.Iterables;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.bean.ChoiceHelper;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.FileUploadAware;

import java.io.File;

/**
 * To add a poll comment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class AddChoice extends AbstractVoteAction implements Preparable, FileUploadAware {

    private static final long serialVersionUID = 1L;

    protected Choice choice;

    private File imageChoice;

    private String imageChoiceContentType;

    private String imageChoiceFileName;

    public Choice getChoice() {
        return choice;
    }

    @Override
    public void addFile(int index, File file) {
        imageChoice = file;
    }

    @Override
    public void addFileContentType(int index, String contentType) {
        imageChoiceContentType = contentType;
    }

    @Override
    public void addFileName(int index, String fileName) {
        imageChoiceFileName = fileName;
    }

    @Override
    public void prepare() throws PollNotFoundException {

        loadPoll();

        ChoiceType choiceType = getPoll().getChoiceType();
        choice = getPollService().getNewChoice(choiceType);

        // Push image choice data from uploaded file
        if (ChoiceType.IMAGE == choiceType && imageChoice != null) {

            String fileName = imageChoiceFileName;
            String location = imageChoice.getAbsolutePath();
            choice.setName(fileName);
            ((PollImageChoice) choice).setLocation(location);
        }
    }

    @Override
    public void validate() {

        ChoiceType choiceType = getPoll().getChoiceType();

        String propName = ChoiceHelper.getValuePropertyName(choiceType);

        Object value = ChoiceHelper.toValue(choice, choiceType);

        // -- Validate value notEmpty
        if (value == null || (value instanceof String && StringUtils.isBlank((String) value))) {
            String typeLabel = getText(choiceType.getI18nKey());
            addFieldError("choice." + propName,
                          _("pollen.error.choice.empty", typeLabel));
        } else {

            // Retrieve existing values to check if the new choice not already exists
            Iterable<Object> pollChoiceValues = ChoiceHelper.toValues(getPoll().getChoice(), choiceType);

            // -- Validate value notExists
            if (Iterables.contains(pollChoiceValues, value)) {
                addFieldError("choice." + propName,
                              _("pollen.error.poll.detected.duplicate.choice.name"));
            }
        }
    }

    @InputConfig(methodName = "prepareVotePage")
    @Override
    public String execute() throws Exception {

        getPollService().addChoice(getPollId(), choice);

        return SUCCESS;
    }

}
