/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;
import org.chorem.pollen.persistence.PollenPersistenceContext;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.bean.PollenUIContext;
import org.chorem.pollen.services.config.PollenServicesConfig;
import org.chorem.pollen.services.service.security.DefaultPollenSecurityContext;
import org.chorem.pollen.services.service.security.PollenSecurityContext;
import org.chorem.pollen.votecounting.api.VoteCountingFactory;

public class DefaultPollenServiceContext
implements PollenServiceContext {
    protected PollenServicesConfig pollenServicesConfig;
    protected Supplier<PollenPersistenceContext> persistenceContextSupplier;
    protected PollenSecurityContext securityContext = DefaultPollenSecurityContext.empty();
    protected Locale locale;
    protected VoteCountingFactory voteCountingFactory;
    protected PollenUIContext uiContext;
    protected final Cache<Object, Object> REQUEST_SCOPE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();

    public void setPollenServicesConfig(PollenServicesConfig pollenServicesConfig) {
        this.pollenServicesConfig = pollenServicesConfig;
    }

    public void setPersistenceContextSupplier(Supplier<PollenPersistenceContext> persistenceContextSupplier) {
        this.persistenceContextSupplier = persistenceContextSupplier;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setSecurityContext(PollenSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Override
    public PollenServicesConfig getPollenServicesConfig() {
        return this.pollenServicesConfig;
    }

    @Override
    public Date getNow() {
        return new Date();
    }

    @Override
    public PollenSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public Optional<PollenUIContext> getUIContext() {
        return Optional.ofNullable(this.uiContext);
    }

    @Override
    public void setUIContext(PollenUIContext uiContext) {
        this.uiContext = uiContext;
    }

    @Override
    public String generateSalt() {
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[32];
        ((Random)r).nextBytes(salt);
        return Base64.encodeBase64String((byte[])salt);
    }

    @Override
    public String generateToken() {
        byte[] decode;
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        try {
            decode = Hex.decodeHex((char[])uuid.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
        return Base64.encodeBase64URLSafeString((byte[])decode);
    }

    @Override
    public String generatePassword() {
        RandomStringGenerator generator = new RandomStringGenerator.Builder().withinRange(48, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).get();
        return generator.generate(8);
    }

    @Override
    public String encodePassword(String salt, String password) {
        String hashAlgorithmName = this.getPollenServicesConfig().getHashAlgorithmName();
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithmName);
            digest.reset();
            digest.update(salt.getBytes());
            byte[] hashedBytes = digest.digest(password.getBytes());
            return Base64.encodeBase64String((byte[])hashedBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PollenTechnicalException("unable to hash password with " + hashAlgorithmName, e);
        }
    }

    @Override
    public VoteCountingFactory getVoteCountingFactory() {
        return this.voteCountingFactory;
    }

    public void setVoteCountingFactory(VoteCountingFactory voteCountingFactory) {
        this.voteCountingFactory = voteCountingFactory;
    }

    @Override
    public PollenPersistenceContext getPersistenceContext() {
        return this.persistenceContextSupplier.get();
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public String getCleanMail(String email) {
        return email == null ? null : StringUtils.lowerCase((String)email.trim());
    }

    @Override
    public <E extends PollenService> E newService(Class<E> serviceClass) {
        PollenService service;
        try {
            Constructor<E> constructor = serviceClass.getConstructor(new Class[0]);
            service = (PollenService)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new PollenTechnicalException("all services must provide a default public constructor", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new PollenTechnicalException("unable to instantiate pollen service", e);
        }
        service.setServiceContext(this);
        return (E)service;
    }

    @Override
    public <K, V> V getRequestScopeCachedValue(K key, Callable<V> loader) {
        try {
            return (V)this.REQUEST_SCOPE_CACHE.get(key, loader);
        }
        catch (ExecutionException e) {
            throw new PollenTechnicalException("Unable to get value from cache", e);
        }
    }
}

