/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.bean.FavoriteListMemberBean;
import org.chorem.pollen.services.service.FavoriteListImportReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavoriteListImportReaderFromLdap
implements FavoriteListImportReader {
    private static final Logger log = LoggerFactory.getLogger(FavoriteListImportReaderFromLdap.class);
    private final String ldapUrl;

    public FavoriteListImportReaderFromLdap(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    @Override
    public List<FavoriteListMemberBean> read(Function<String, String> emailCleaner) {
        String cleanLdapUrl;
        LinkedList<FavoriteListMemberBean> result = new LinkedList<FavoriteListMemberBean>();
        Properties env = new Properties();
        Pattern loginLdapPattern = Pattern.compile("ldaps?://(([^:]+):([^@]+)@)?.*");
        Matcher matcher = loginLdapPattern.matcher(this.ldapUrl);
        if (matcher.find() && matcher.group(1) != null) {
            env.put("java.naming.security.authentication", "simple");
            if (matcher.group(2) != null) {
                String login = URLDecoder.decode(matcher.group(2), StandardCharsets.UTF_8);
                log.info("Authentification aupr\u00e8s du LDAP en utilisant l'identit\u00e9 '{}'", (Object)login);
                env.put("java.naming.security.principal", login);
            }
            if (matcher.group(3) != null) {
                String password = URLDecoder.decode(matcher.group(3), StandardCharsets.UTF_8);
                env.put("java.naming.security.credentials", password);
            }
            cleanLdapUrl = this.ldapUrl.replace(matcher.group(1), "");
        } else {
            cleanLdapUrl = this.ldapUrl;
        }
        try {
            InitialDirContext ictx = new InitialDirContext(env);
            SearchControls control = new SearchControls();
            control.setSearchScope(2);
            NamingEnumeration<SearchResult> e = ictx.search(cleanLdapUrl, null, control);
            if (!e.hasMore()) {
                log.warn("Aucun r\u00e9sultat");
            }
            while (e.hasMore()) {
                SearchResult r = e.next();
                log.info("{} / Attributs: {}", (Object)r.getNameInNamespace(), (Object)r.getAttributes());
                Attribute attrName = r.getAttributes().get("cn");
                Attribute attrEmail = r.getAttributes().get("mail");
                if (attrName == null || attrEmail == null) continue;
                String memberName = attrName.get().toString().trim();
                String email = emailCleaner.apply(attrEmail.get().toString());
                FavoriteListMemberBean member = new FavoriteListMemberBean();
                member.setName(memberName);
                member.setEmail(email);
                member.setWeight(1.0);
                result.add(member);
            }
        }
        catch (NamingException ne) {
            throw new PollenTechnicalException("Unable to read data from LDAP", ne);
        }
        return result;
    }
}

