/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.chorem.pollen.services.service.InvalidFormException;

public class ErrorMap {
    protected final Multimap<String, String> errors = ArrayListMultimap.create();

    public void addError(String key, String error) {
        this.errors.put((Object)key, (Object)error);
    }

    public void addErrors(String key, Iterable<String> error) {
        this.errors.putAll((Object)key, error);
    }

    public void addAllErrors(ErrorMap errorMap) {
        this.errors.putAll(errorMap.getErrors());
    }

    public void addAllErrors(Multimap<String, String> errors) {
        this.errors.putAll(errors);
    }

    public void copyTo(ErrorMap errorMap, String prefix) {
        for (String key : this.errors.keySet()) {
            Collection errors = this.errors.get((Object)key);
            errorMap.addErrors(prefix + key, errors);
        }
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public Multimap<String, String> getErrors() {
        return this.errors;
    }

    public void failIfNotEmpty() throws InvalidFormException {
        if (!this.errors.isEmpty()) {
            throw new InvalidFormException(this.errors);
        }
    }
}

