/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.security;

import java.util.Optional;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;

public interface PollenSecurityContext {
    public void setMainPrincipal(PollenPrincipal var1);

    public Optional<PollenPrincipal> getMainPrincipal();

    public void setPollenUser(PollenUser var1);

    public Optional<PollenUser> getPollenUser();

    default public boolean isConnected() {
        return this.getPollenUser().isPresent();
    }

    default public boolean isAdmin() {
        return this.getPollenUser().isPresent() && this.getPollenUser().orElseThrow().isAdministrator();
    }

    default public Optional<String> getPrincipalOrConnectedUserName() {
        if (this.getMainPrincipal().isPresent()) {
            return this.getMainPrincipal().map(PollenPrincipal::getName);
        }
        if (this.getPollenUser().isPresent()) {
            return this.getPollenUser().map(PollenUser::getName);
        }
        return Optional.empty();
    }
}

