package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class VoteDAOAbstract<E extends Vote> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Vote.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.Vote;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<VotingList> list = getContext()
                                                    .getDAO(VotingList.class)
                                                    .findAllByProperties(VotingList.PROPERTY_VOTE, entity);
                                            for (VotingList item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getVote())) {
                                                    item.setVote(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByWeight(double v) throws TopiaException {
        E result = findByProperty(Vote.PROPERTY_WEIGHT, v);
        return result;
    }

    public List<E> findAllByWeight(double v) throws TopiaException {
        List<E> result = findAllByProperty(Vote.PROPERTY_WEIGHT, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Vote.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Vote.PROPERTY_COMMENT, v);
        return result;
    }

    public E findByAnonymous(boolean v) throws TopiaException {
        E result = findByProperty(Vote.PROPERTY_ANONYMOUS, v);
        return result;
    }

    public List<E> findAllByAnonymous(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Vote.PROPERTY_ANONYMOUS, v);
        return result;
    }

    public E findByPollAccount(PollAccount v) throws TopiaException {
        E result = findByProperty(Vote.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    public List<E> findAllByPollAccount(PollAccount v) throws TopiaException {
        List<E> result = findAllByProperty(Vote.PROPERTY_POLL_ACCOUNT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Poll.class) {
            PollDAO dao = (PollDAO)
                getContext().getDAO(Poll.class);
            tmp = dao.findAllContainsVote(entity);
            result.addAll(tmp);
        }

        if (type == PollAccount.class) {
            PollAccountDAO dao = (PollAccountDAO)
                getContext().getDAO(PollAccount.class);
            tmp = dao.findAllContainsVote(entity);
            result.addAll(tmp);
        }

        if (type == VotingList.class) {
            VotingListDAO dao = (VotingListDAO)
                getContext().getDAO(VotingList.class);
            tmp = dao.findAllByVote(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(Poll.class, entity);
        if (!list.isEmpty()) {
            result.put(Poll.class, list);
        }

        list = findUsages(PollAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(PollAccount.class, list);
        }

        list = findUsages(VotingList.class, entity);
        if (!list.isEmpty()) {
            result.put(VotingList.class, list);
        }

        return result;
    }

} //VoteDAOAbstract<E extends Vote>
