package org.chorem.pollen.business.persistence;
/*
 * #%L
 * Pollen :: Persistence
 * $Id: PollVoteVisibility.java 3698 2012-09-23 13:01:38Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PollVoteVisibility.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import static org.nuiton.i18n.I18n.n_;

/**
 * Define how vote can be visible in a poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public enum PollVoteVisibility implements I18nAble {

    /**
     * Nobody can see vote.
     * <p/>
     * This means every votes are anonymous.
     */
    NOBODY(n_("pollen.pollVoteVisibilty.nobody"),
           n_("pollen.pollVoteVisibilty.nobody.help")),
    /** Only creator (or Pollen adin) can see votes. */
    CREATOR_ONLY(n_("pollen.pollVoteVisibilty.creatorOnly"),
                 n_("pollen.pollVoteVisibilty.creatorOnly.help")),
    /** Only participant of poll can see votes. */
    PARTICIPANT_ONLY(n_("pollen.pollVoteVisibilty.participantOnly"),
                     n_("pollen.pollVoteVisibilty.participantOnly.help")),
    /** Every body can see votes. */
    EVERYBODY(n_("pollen.pollVoteVisibilty.everybody"),
              n_("pollen.pollVoteVisibilty.everybody.help"));

    private final String i18nKey;

    private final String i18nHelpKey;

    PollVoteVisibility(String i18nKey, String i18nHelpKey) {
        this.i18nKey = i18nKey;
        this.i18nHelpKey = i18nHelpKey;
    }

    @Override
    public String getI18nKey() {
        return i18nKey;
    }

    public String getI18nHelpKey() {
        return i18nHelpKey;
    }

    public static PollVoteVisibility valueOf(int ordinal) {

        PollVoteVisibility result = null;
        for (PollVoteVisibility curr : PollVoteVisibility.values()) {
            if (curr.ordinal() == ordinal) {
                result = curr;
                break;
            }
        }
        return result;
    }
}
