package org.chorem.pollen.business.persistence;
/*
 * #%L
 * Pollen :: Persistence
 * $Id: PollCommentVisibility.java 3698 2012-09-23 13:01:38Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PollCommentVisibility.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import static org.nuiton.i18n.I18n.n_;

/**
 * Define how comment can be shown in a poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public enum PollCommentVisibility implements I18nAble {

    /** Nobody can see comments. */
    NOBODY(n_("pollen.pollCommentVisibilty.nobody")),
    /** Every body can see comments. */
    EVERYBODY(n_("pollen.pollCommentVisibilty.everybody"));

    private final String i18nKey;

    PollCommentVisibility(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    @Override
    public String getI18nKey() {
        return i18nKey;
    }

    public static PollCommentVisibility valueOf(int ordinal) {

        PollCommentVisibility result = null;
        for (PollCommentVisibility curr : PollCommentVisibility.values()) {
            if (curr.ordinal() == ordinal) {
                result = curr;
                break;
            }
        }
        return result;
    }
}
