/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenConfigurationOption;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;

public class PollenConfiguration {
    protected static final Log log = LogFactory.getLog(PollenConfiguration.class);
    protected ApplicationConfig applicationConfig;

    public PollenConfiguration() {
        this("pollen.properties", null);
    }

    public PollenConfiguration(String file, Properties defaultOptions) {
        if (log.isInfoEnabled()) {
            log.info((Object)(this + " is initializing..."));
        }
        this.applicationConfig = new ApplicationConfig(defaultOptions, file);
        try {
            this.applicationConfig.loadDefaultOptions((ApplicationConfig.OptionDef[])PollenConfigurationOption.values());
            this.applicationConfig.parse(new String[0]);
        }
        catch (ArgumentsParserException e) {
            throw new PollenTechnicalException("Could not parse configuration", e);
        }
        String applicationUrl = this.applicationConfig.getOption(PollenConfigurationOption.APPLICATION_URL.key);
        if (StringUtils.isBlank((CharSequence)applicationUrl)) {
            throw new IllegalStateException("No application url defined in configuration, please fill the property '" + PollenConfigurationOption.APPLICATION_URL.key + "'");
        }
        this.createDirectory(PollenConfigurationOption.EMAIL_DIR);
        this.createDirectory(PollenConfigurationOption.FEED_DIR);
        this.createDirectory(PollenConfigurationOption.IMG_DIR);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parsed options in config file" + this.applicationConfig.getOptions()));
        }
    }

    public URL getApplicationUrl() {
        URL result = this.applicationConfig.getOptionAsURL(PollenConfigurationOption.APPLICATION_URL.key);
        return result;
    }

    public ChoiceType getDefaultChoiceType() {
        ChoiceType result = (ChoiceType)this.applicationConfig.getOption(ChoiceType.class, PollenConfigurationOption.DEFAULT_CHOICE_TYPE.key);
        return result;
    }

    public VoteCountingType getDefaultVoteCountingType() {
        VoteCountingType result = (VoteCountingType)this.applicationConfig.getOption(VoteCountingType.class, PollenConfigurationOption.DEFAULT_VOTE_COUNTING_TYPE.key);
        return result;
    }

    public PollType getDefaultPollType() {
        PollType result = (PollType)this.applicationConfig.getOption(PollType.class, PollenConfigurationOption.DEFAULT_POLL_TYPE.key);
        return result;
    }

    public String getAdminLogin() {
        String result = this.applicationConfig.getOption(PollenConfigurationOption.ADMIN_LOGIN.key);
        return result;
    }

    public String getAdminPassword() {
        String result = this.applicationConfig.getOption(PollenConfigurationOption.ADMIN_PASSWORD.key);
        return result;
    }

    public String getAdminEmail() {
        String result = this.applicationConfig.getOption(PollenConfigurationOption.ADMIN_EMAIL.key);
        return result;
    }

    public String getContactEmail() {
        String result = this.applicationConfig.getOption(PollenConfigurationOption.CONTACT_EMAIL.key);
        return result;
    }

    public String getEmailHost() {
        String result = this.applicationConfig.getOption(PollenConfigurationOption.EMAIL_HOST.key);
        return result;
    }

    public int getEmailPort() {
        int result = this.applicationConfig.getOptionAsInt(PollenConfigurationOption.EMAIL_PORT.key);
        return result;
    }

    public String getEmailFrom() {
        String result = this.applicationConfig.getOption(PollenConfigurationOption.EMAIL_FROM.key);
        return result;
    }

    public File getEmailDirectory() {
        File result = this.applicationConfig.getOptionAsFile(PollenConfigurationOption.EMAIL_DIR.key);
        return result;
    }

    public File getFeedDirectory() {
        File result = this.applicationConfig.getOptionAsFile(PollenConfigurationOption.FEED_DIR.key);
        return result;
    }

    public File getImageDirectory() {
        File result = this.applicationConfig.getOptionAsFile(PollenConfigurationOption.IMG_DIR.key);
        return result;
    }

    public int getNbVotesPerPage() {
        int result = this.applicationConfig.getOptionAsInt(PollenConfigurationOption.NB_VOTES_PER_PAGE.key);
        return result;
    }

    public String getCharset() {
        String result = this.applicationConfig.getOption(PollenConfigurationOption.CHARSET.key);
        return result;
    }

    public Version getVersion() {
        Version result = this.applicationConfig.getOptionAsVersion("pollen.version");
        return result;
    }

    public void setAdminLogin(String adminLogin) {
        this.applicationConfig.setOption(PollenConfigurationOption.ADMIN_LOGIN.key, adminLogin);
    }

    public void setAdminPassword(String adminPassword) {
        this.applicationConfig.setOption(PollenConfigurationOption.ADMIN_PASSWORD.key, adminPassword);
    }

    public void setAdminEmail(String adminEmail) {
        this.applicationConfig.setOption(PollenConfigurationOption.ADMIN_EMAIL.key, adminEmail);
    }

    public void setContactEmail(String contactEmail) {
        this.applicationConfig.setOption(PollenConfigurationOption.CONTACT_EMAIL.key, contactEmail);
    }

    public void setEmailHost(String emailHost) {
        this.applicationConfig.setOption(PollenConfigurationOption.EMAIL_HOST.key, emailHost);
    }

    public void setEmailPort(int emailPort) {
        this.applicationConfig.setOption(PollenConfigurationOption.EMAIL_PORT.key, String.valueOf(emailPort));
    }

    public void setEmailFrom(String emailFrom) {
        this.applicationConfig.setOption(PollenConfigurationOption.EMAIL_FROM.key, emailFrom);
    }

    public void setEmailDirectory(File emailDirectory) {
        this.applicationConfig.setOption(PollenConfigurationOption.EMAIL_DIR.key, emailDirectory.getAbsolutePath());
    }

    public void setFeedDirectory(File feedDirectory) {
        this.applicationConfig.setOption(PollenConfigurationOption.FEED_DIR.key, feedDirectory.getAbsolutePath());
    }

    public void setImageDirectory(File imageDirectory) {
        this.applicationConfig.setOption(PollenConfigurationOption.IMG_DIR.key, imageDirectory.getAbsolutePath());
    }

    public void setNbVotesPerPage(int nbVotesPerPage) {
        this.applicationConfig.setOption(PollenConfigurationOption.NB_VOTES_PER_PAGE.key, String.valueOf(nbVotesPerPage));
    }

    public void setCharset(String charset) {
        this.applicationConfig.setOption(PollenConfigurationOption.CHARSET.key, charset);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public Properties getProperties() {
        Properties result = this.applicationConfig.getFlatOptions();
        return result;
    }

    public boolean getOptionAsBoolean(String propertyName) {
        Boolean result = this.applicationConfig.getOptionAsBoolean(propertyName);
        return result != null && result != false;
    }

    private void createDirectory(PollenConfigurationOption key) {
        File directory = this.applicationConfig.getOptionAsFile(key.getKey());
        Preconditions.checkNotNull((Object)directory, (Object)("Could not find directory " + directory + " (key " + (Object)((Object)key) + "in your configuration file named echobase.properties)"));
        if (log.isInfoEnabled()) {
            log.info((Object)((Object)((Object)key) + " = " + directory));
        }
        try {
            FileUtil.createDirectoryIfNecessary((File)directory);
        }
        catch (IOException e) {
            throw new PollenTechnicalException("Could not create directory " + directory, e);
        }
    }
}

