/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Comment}.
 */
public abstract class CommentAbstract extends TopiaEntityAbstract implements Comment {

    public String text;

    public Date postDate;

    public Poll poll;

    public PollAccount pollAccount;

    /**
     * Constructeur de CommentAbstract par défaut.
     */
    public CommentAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Comment.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Comment.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "text", String.class, text);
        visitor.visit(this, "postDate", Date.class, postDate);
        visitor.visit(this, "poll", Poll.class, poll);
        visitor.visit(this, "pollAccount", PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Comment#setText(String)
     */
    @Override
    public void setText(String value) {
        String _oldValue = this.text;
        fireOnPreWrite("text", _oldValue, value);
        this.text = value;
        fireOnPostWrite("text", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Comment#getText()
     */
    @Override
    public String getText() {
        fireOnPreRead("text", text);
        String result = this.text;
        fireOnPostRead("text", text);
        return result;
    }

    /* (non-Javadoc)
     * @see Comment#setPostDate(Date)
     */
    @Override
    public void setPostDate(Date value) {
        Date _oldValue = this.postDate;
        fireOnPreWrite("postDate", _oldValue, value);
        this.postDate = value;
        fireOnPostWrite("postDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Comment#getPostDate()
     */
    @Override
    public Date getPostDate() {
        fireOnPreRead("postDate", postDate);
        Date result = this.postDate;
        fireOnPostRead("postDate", postDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Comment#setPoll(Poll)
     */
    @Override
    public void setPoll(Poll value) {
        Poll _oldValue = this.poll;
        fireOnPreWrite("poll", _oldValue, value);
        this.poll = value;
        fireOnPostWrite("poll", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Comment#getPoll()
     */
    @Override
    public Poll getPoll() {
        fireOnPreRead("poll", poll);
        Poll result = this.poll;
        fireOnPostRead("poll", poll);
        return result;
    }

    /* (non-Javadoc)
     * @see Comment#setPollAccount(PollAccount)
     */
    @Override
    public void setPollAccount(PollAccount value) {
        PollAccount _oldValue = this.pollAccount;
        fireOnPreWrite("pollAccount", _oldValue, value);
        this.pollAccount = value;
        fireOnPostWrite("pollAccount", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Comment#getPollAccount()
     */
    @Override
    public PollAccount getPollAccount() {
        fireOnPreRead("pollAccount", pollAccount);
        PollAccount result = this.pollAccount;
        fireOnPostRead("pollAccount", pollAccount);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("text", this.text).
            append("postDate", this.postDate).
         toString();
        return result;
    }
        
} //CommentAbstract
