/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataPersonListConverter;
import org.chorem.pollen.business.converters.DataVotingListConverter;
import org.chorem.pollen.business.dto.PersonListDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListDAO;
import org.chorem.pollen.business.services.ServiceList;
import org.chorem.pollen.business.services.ServicePollAccountImpl;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceListImpl
implements ServiceList {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private VotingListDAO votingListDAO = null;
    private PersonListDAO personListDAO = null;
    private DataVotingListConverter votingListConverter = new DataVotingListConverter();
    private DataPersonListConverter personListConverter = new DataPersonListConverter();
    private static final Log log = LogFactory.getLog(ServiceListImpl.class);

    @Override
    public String createVotingList(VotingListDTO votingList) {
        TopiaContext transaction = null;
        String topiaId = "";
        try {
            transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(transaction);
            VotingList votingListEntity = (VotingList)this.votingListDAO.create(new Object[0]);
            this.votingListConverter.setTransaction(transaction);
            this.votingListConverter.populateVotingListEntity(votingList, votingListEntity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            for (PollAccountDTO account : votingList.getPollAccountDTOs()) {
                if (spa.findPollAccountById(account.getId()) != null) continue;
                account.setId(spa.createPollAccount(account));
            }
            this.votingListConverter.populatePersonVotingList(votingList, votingListEntity);
            topiaId = votingListEntity.getTopiaId();
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return "";
        }
    }

    @Override
    public List<VotingList> createVotingLists(List<VotingListDTO> votingLists, String pollId, TopiaContext trans) {
        if (votingLists.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<VotingList> result = null;
        try {
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(trans);
            this.votingListConverter.setTransaction(trans);
            result = new ArrayList<VotingList>();
            for (VotingListDTO votingList : votingLists) {
                VotingList votingListEntity = (VotingList)this.votingListDAO.create(new Object[0]);
                votingList.setPollId(pollId);
                this.votingListConverter.populateVotingListEntity(votingList, votingListEntity);
                ServicePollAccountImpl spa = new ServicePollAccountImpl();
                for (PollAccountDTO account : votingList.getPollAccountDTOs()) {
                    if (spa.findPollAccountById(account.getId()) != null) continue;
                    account.setId(spa.createPollAccount(account));
                }
                this.votingListConverter.populatePersonVotingList(votingList, votingListEntity);
                result.add(votingListEntity);
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, trans);
            return null;
        }
    }

    @Override
    public boolean updateVotingList(VotingListDTO votingList) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(transaction);
            VotingList entity = (VotingList)this.votingListDAO.findByTopiaId(votingList.getId());
            this.votingListConverter.setTransaction(transaction);
            this.votingListConverter.populateVotingListEntity(votingList, entity);
            this.votingListDAO.update(entity);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + votingList.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public boolean deleteVotingList(String votingListId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(transaction);
            VotingList entity = (VotingList)this.votingListDAO.findByTopiaId(votingListId);
            this.votingListDAO.delete(entity);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + votingListId));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public VotingListDTO findVotingListById(String votingListId) {
        TopiaContext transaction = null;
        VotingListDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(transaction);
            VotingList votingListEntity = (VotingList)this.votingListDAO.findByTopiaId(votingListId);
            if (votingListEntity != null) {
                this.votingListConverter.setTransaction(transaction);
                result = this.votingListConverter.createVotingListDTO(votingListEntity);
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public List<VotingListDTO> findVotingListByName(String name) {
        TopiaContext transaction = null;
        List<VotingListDTO> results = null;
        List<VotingList> votingListEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(transaction);
            votingListEntities = this.votingListDAO.findAllByName(name);
            this.votingListConverter.setTransaction(transaction);
            results = this.votingListConverter.createVotingListDTOs(votingListEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public List<VotingListDTO> selectVotingList(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<VotingListDTO> results = null;
        List votingListEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.votingListDAO = PollenModelDAOHelper.getVotingListDAO(transaction);
            if (properties == null) {
                votingListEntities = this.votingListDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : toutes les listes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                votingListEntities = this.votingListDAO.findAllByProperties(properties);
            }
            this.votingListConverter.setTransaction(transaction);
            results = this.votingListConverter.createVotingListDTOs(votingListEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public String createPersonList(PersonListDTO personList) {
        TopiaContext transaction = null;
        String topiaId = "";
        try {
            transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(transaction);
            PersonList entity = (PersonList)this.personListDAO.create(new Object[0]);
            this.personListConverter.setTransaction(transaction);
            this.personListConverter.populatePersonListEntity(personList, entity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            for (PollAccountDTO account : personList.getPollAccountDTOs()) {
                account.setPersonListId(entity.getTopiaId());
            }
            entity.setPollAccount(spa.createPollAccounts(personList.getPollAccountDTOs(), transaction));
            topiaId = entity.getTopiaId();
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return "";
        }
    }

    @Override
    public boolean createPersonLists(List<PersonListDTO> personLists, String userId, TopiaContext trans) {
        if (personLists.isEmpty() || userId.length() == 0) {
            return false;
        }
        try {
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(trans);
            this.personListConverter.setTransaction(trans);
            for (PersonListDTO personList : personLists) {
                PersonList entity = (PersonList)this.personListDAO.create(new Object[0]);
                ServicePollAccountImpl spa = new ServicePollAccountImpl();
                for (PollAccountDTO account : personList.getPollAccountDTOs()) {
                    account.setPersonListId(entity.getTopiaId());
                }
                entity.setPollAccount(spa.createPollAccounts(personList.getPollAccountDTOs(), trans));
                personList.setUserId(userId);
                this.personListConverter.populatePersonListEntity(personList, entity);
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, trans);
            return false;
        }
    }

    @Override
    public boolean updatePersonList(PersonListDTO personList) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(transaction);
            PersonList entity = (PersonList)this.personListDAO.findByTopiaId(personList.getId());
            this.personListConverter.setTransaction(transaction);
            this.personListConverter.populatePersonListEntity(personList, entity);
            this.personListDAO.update(entity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            for (PollAccountDTO pollAccountDTO : personList.getPollAccountDTOs()) {
                pollAccountDTO.setPersonListId(entity.getTopiaId());
                boolean updated = spa.updatePollAccount(pollAccountDTO);
                if (!updated) {
                    pollAccountDTO.setId(spa.createPollAccount(pollAccountDTO));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("PollAccount " + pollAccountDTO.getVotingId() + " (" + pollAccountDTO.getId() + ") updated: " + updated));
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + personList.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public boolean deletePersonList(String personListId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(transaction);
            PersonList entity = (PersonList)this.personListDAO.findByTopiaId(personListId);
            this.personListDAO.delete(entity);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + personListId));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public boolean deletePersonLists(String userId) {
        TopiaContext transaction = null;
        ArrayList<PersonList> personListEntities = null;
        UserAccountDAO userDAO = null;
        try {
            transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            personListEntities = new ArrayList<PersonList>();
            personListEntities.addAll(user.getFavoriteList());
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(transaction);
            for (PersonList entity : personListEntities) {
                this.personListDAO.delete(entity);
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)(personListEntities.size() + " entities deleted for user: " + userId));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public PersonListDTO findPersonListById(String personListId) {
        TopiaContext transaction = null;
        PersonListDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(transaction);
            PersonList personListEntity = (PersonList)this.personListDAO.findByTopiaId(personListId);
            if (personListEntity != null) {
                this.personListConverter.setTransaction(transaction);
                result = this.personListConverter.createPersonListDTO(personListEntity);
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public List<PersonListDTO> findPersonListByName(String name) {
        TopiaContext transaction = null;
        List<PersonListDTO> results = null;
        List<PersonList> personListEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(transaction);
            personListEntities = this.personListDAO.findAllByName(name);
            this.personListConverter.setTransaction(transaction);
            results = this.personListConverter.createPersonListDTOs(personListEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public List<PersonListDTO> findPersonListByUser(String userId) {
        TopiaContext transaction = null;
        List<PersonListDTO> results = null;
        ArrayList<PersonList> personListEntities = null;
        UserAccountDAO userDAO = null;
        try {
            transaction = this.rootContext.beginTransaction();
            userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount user = (UserAccount)userDAO.findByTopiaId(userId);
            personListEntities = new ArrayList<PersonList>();
            personListEntities.addAll(user.getFavoriteList());
            this.personListConverter.setTransaction(transaction);
            results = this.personListConverter.createPersonListDTOs(personListEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public List<PersonListDTO> selectPersonList(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<PersonListDTO> results = null;
        List personListEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.personListDAO = PollenModelDAOHelper.getPersonListDAO(transaction);
            if (properties == null) {
                personListEntities = this.personListDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : toutes les listes ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                personListEntities = this.personListDAO.findAllByProperties(properties);
            }
            this.personListConverter.setTransaction(transaction);
            results = this.personListConverter.createPersonListDTOs(personListEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }
}

