/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link PreventRule}.
 */
public abstract class PreventRuleAbstract extends TopiaEntityAbstract implements PreventRule {

    public String scope;

    public int sensibility;

    public Boolean repeated;

    public String method;

    public Poll poll;

    /**
     * Constructeur de PreventRuleAbstract par défaut.
     */
    public PreventRuleAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PreventRule.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PreventRule.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "scope", String.class, scope);
        visitor.visit(this, "sensibility", int.class, sensibility);
        visitor.visit(this, "repeated", Boolean.class, repeated);
        visitor.visit(this, "method", String.class, method);
        visitor.visit(this, "poll", Poll.class, poll);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see PreventRule#setScope(String)
     */
    @Override
    public void setScope(String value) {
        String _oldValue = this.scope;
        fireOnPreWrite("scope", _oldValue, value);
        this.scope = value;
        fireOnPostWrite("scope", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PreventRule#getScope()
     */
    @Override
    public String getScope() {
        fireOnPreRead("scope", scope);
        String result = this.scope;
        fireOnPostRead("scope", scope);
        return result;
    }

    /* (non-Javadoc)
     * @see PreventRule#setSensibility(int)
     */
    @Override
    public void setSensibility(int value) {
        int _oldValue = this.sensibility;
        fireOnPreWrite("sensibility", _oldValue, value);
        this.sensibility = value;
        fireOnPostWrite("sensibility", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PreventRule#getSensibility()
     */
    @Override
    public int getSensibility() {
        fireOnPreRead("sensibility", sensibility);
        int result = this.sensibility;
        fireOnPostRead("sensibility", sensibility);
        return result;
    }

    /* (non-Javadoc)
     * @see PreventRule#setRepeated(Boolean)
     */
    @Override
    public void setRepeated(Boolean value) {
        Boolean _oldValue = this.repeated;
        fireOnPreWrite("repeated", _oldValue, value);
        this.repeated = value;
        fireOnPostWrite("repeated", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PreventRule#getRepeated()
     */
    @Override
    public Boolean getRepeated() {
        fireOnPreRead("repeated", repeated);
        Boolean result = this.repeated;
        fireOnPostRead("repeated", repeated);
        return result;
    }

    /* (non-Javadoc)
     * @see PreventRule#setMethod(String)
     */
    @Override
    public void setMethod(String value) {
        String _oldValue = this.method;
        fireOnPreWrite("method", _oldValue, value);
        this.method = value;
        fireOnPostWrite("method", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PreventRule#getMethod()
     */
    @Override
    public String getMethod() {
        fireOnPreRead("method", method);
        String result = this.method;
        fireOnPostRead("method", method);
        return result;
    }

    /* (non-Javadoc)
     * @see PreventRule#setPoll(Poll)
     */
    @Override
    public void setPoll(Poll value) {
        Poll _oldValue = this.poll;
        fireOnPreWrite("poll", _oldValue, value);
        this.poll = value;
        fireOnPostWrite("poll", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PreventRule#getPoll()
     */
    @Override
    public Poll getPoll() {
        fireOnPreRead("poll", poll);
        Poll result = this.poll;
        fireOnPostRead("poll", poll);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("scope", this.scope).
            append("sensibility", this.sensibility).
            append("repeated", this.repeated).
            append("method", this.method).
         toString();
        return result;
    }
        
} //PreventRuleAbstract
