/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementchart;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.FinancialStatementService;
import org.chorem.lima.business.exceptions.AlreadyExistFinancialStatementException;
import org.chorem.lima.business.exceptions.NotAllowedLabelException;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartViewHandler;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class FinancialStatementChartTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);
    protected final FinancialStatementService financialStatementService = (FinancialStatementService)LimaServiceFactory.getService(FinancialStatementService.class);
    Binder<FinancialStatement, FinancialStatement> binderFinancialStatement;
    protected ErrorHelper errorHelper;

    public FinancialStatementChartTreeTableModel() {
        super((Object)new FinancialStatementImpl());
        FinancialStatement master = (FinancialStatement)this.root;
        master.addAllSubFinancialStatements((Iterable)this.financialStatementService.getRootFinancialStatements());
        this.errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
        this.binderFinancialStatement = BinderFactory.newBinder(FinancialStatement.class);
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int column) {
        String res = null;
        switch (column) {
            case 0: {
                res = I18n.t((String)"lima.table.label", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n.t((String)"lima.table.debitCredit", (Object[])new Object[0]);
                break;
            }
            case 2: {
                res = I18n.t((String)"lima.table.debit", (Object[])new Object[0]);
                break;
            }
            case 3: {
                res = I18n.t((String)"lima.table.credit", (Object[])new Object[0]);
                break;
            }
            case 4: {
                res = I18n.t((String)"lima.table.provisionDeprecation", (Object[])new Object[0]);
            }
        }
        return res;
    }

    public int getChildCount(Object node) {
        FinancialStatement parentFinancialStatementHeader = (FinancialStatement)node;
        int result = parentFinancialStatementHeader.sizeSubFinancialStatements();
        return result;
    }

    public Object getChild(Object parent, int index) {
        FinancialStatement parentFinancialStatement = (FinancialStatement)parent;
        ArrayList financialStatements = Lists.newArrayList((Iterable)parentFinancialStatement.getSubFinancialStatements());
        FinancialStatement result = (FinancialStatement)financialStatements.get(index);
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        FinancialStatement parentFinancialStatement = (FinancialStatement)parent;
        ArrayList financialStatements = Lists.newArrayList((Iterable)parentFinancialStatement.getSubFinancialStatements());
        int result = financialStatements.indexOf(child);
        return result;
    }

    public Object getValueAt(Object node, int column) {
        String result = "n/a";
        FinancialStatement financialStatement = (FinancialStatement)node;
        switch (column) {
            case 0: {
                result = financialStatement.getLabel();
                break;
            }
            case 1: {
                result = financialStatement.getAccounts();
                break;
            }
            case 2: {
                result = financialStatement.getDebitAccounts();
                break;
            }
            case 3: {
                result = financialStatement.getCreditAccounts();
                break;
            }
            case 4: {
                result = financialStatement.getProvisionDeprecationAccounts();
            }
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public boolean isLeaf(Object node) {
        FinancialStatement financialStatement = (FinancialStatement)node;
        return financialStatement != this.getRoot() && !financialStatement.isHeader();
    }

    public void refreshTree() {
        FinancialStatement master = (FinancialStatement)this.root;
        master.setSubFinancialStatements((Collection)this.financialStatementService.getRootFinancialStatements());
        this.modelSupport.fireNewRoot();
    }

    public void addFinancialStatement(TreePath path, FinancialStatement financialStatement) {
        FinancialStatement parentFinancialStatementHeader = (FinancialStatement)path.getLastPathComponent();
        try {
            if (parentFinancialStatementHeader == this.getRoot()) {
                financialStatement = this.financialStatementService.createMasterFinacialStatements(financialStatement);
                parentFinancialStatementHeader.addSubFinancialStatements(financialStatement);
            } else {
                financialStatement = this.financialStatementService.createFinancialStatement(parentFinancialStatementHeader, financialStatement);
                this.binderFinancialStatement.copy((Object)financialStatement.getMasterFinancialStatement(), (Object)parentFinancialStatementHeader, new String[0]);
            }
            this.modelSupport.fireTreeStructureChanged(path);
        }
        catch (AlreadyExistFinancialStatementException alreadyExistFinancialStatement) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.financialStatement.error.alreadyExistFinancialStatement", (Object[])new Object[]{alreadyExistFinancialStatement.getFinancialStatementLabel(), alreadyExistFinancialStatement.getMasterLabel()}));
        }
        catch (NotAllowedLabelException notAllowedLabel) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.error.notAllowedLabel", (Object[])new Object[]{notAllowedLabel.getLabel()}));
        }
    }

    public void updateFinancialStatement(TreePath path, FinancialStatement financialStatement) {
        FinancialStatement updateFinancialStatement = this.financialStatementService.updateFinancialStatement(financialStatement);
        this.binderFinancialStatement.copy((Object)updateFinancialStatement, (Object)financialStatement, new String[0]);
        this.modelSupport.firePathChanged(path);
    }

    public void removeFinancialStatementObject(TreePath path, FinancialStatement financialStatement) {
        int index = this.getIndexOfChild(path.getParentPath().getLastPathComponent(), financialStatement);
        this.financialStatementService.removeFinancialStatement(financialStatement);
        this.modelSupport.fireChildRemoved(path.getParentPath(), index, (Object)financialStatement);
    }
}

