/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybook;

import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.EntryBookServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.nuiton.i18n.I18n;

public class EntryBookTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 7578692417919755647L;
    private static final Log log = LogFactory.getLog(EntryBookTableModel.class);
    protected EntryBookServiceMonitorable entryBookService = LimaServiceFactory.getInstance().getService(EntryBookServiceMonitorable.class);

    public EntryBookTableModel() {
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
    }

    @Override
    public int getRowCount() {
        int result;
        block2: {
            result = 0;
            try {
                result = this.entryBookService.getAllEntryBooks().size();
            }
            catch (LimaException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get all entrybooks", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.code", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.label", (Object[])new Object[0]);
            }
        }
        return res;
    }

    public EntryBook getEntryBookAtRow(int row) throws LimaException {
        EntryBook entryBook = null;
        entryBook = (EntryBook)this.entryBookService.getAllEntryBooks().get(row);
        return entryBook;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String result;
        block6: {
            result = null;
            try {
                EntryBook entryBook = this.getEntryBookAtRow(row);
                switch (column) {
                    case 0: {
                        result = entryBook.getCode();
                        break;
                    }
                    case 1: {
                        result = entryBook.getLabel();
                    }
                }
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"Can't get EntryBook", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addEntryBook(EntryBook entryBook) throws LimaException {
        this.entryBookService.createEntryBook(entryBook);
        int row = this.entryBookService.getAllEntryBooks().indexOf(entryBook);
        this.fireTableRowsInserted(row, row);
    }

    public void updateEntryBook(EntryBook entryBook) throws LimaException {
        this.entryBookService.updateEntryBook(entryBook);
        int row = this.entryBookService.getAllEntryBooks().indexOf(entryBook);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeEntryBook(EntryBook entryBook) throws LimaException {
        int row = this.entryBookService.getAllEntryBooks().indexOf(entryBook);
        this.entryBookService.removeEntryBook(entryBook);
        this.fireTableRowsDeleted(row, row);
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importEntryBooks") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.fireTableDataChanged();
        }
    }
}

