/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementReportViewHandler.java 3191 2011-06-30 09:47:13Z vsalaun $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5/lima-swing/src/main/java/org/chorem/lima/ui/financialstatementreport/FinancialStatementReportViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialstatementreport;

import static org.nuiton.i18n.I18n._;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.swing.JOptionPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.ErrorHelper;

/**
 * Handler associated with accounts reports view.
 * 
 * @author chatellier
 * @version $Revision: 3191 $
 * 
 * Last update : $Date: 2011-06-30 11:47:13 +0200 (Thu, 30 Jun 2011) $
 * By : $Author: vsalaun $
 */
public class FinancialStatementReportViewHandler {
    
    /** log. */
    private static final Log log = LogFactory.getLog(FinancialStatementReportViewHandler.class);

    protected FinancialStatementReportView view;
    
    protected FinancialStatementReportTableModel model;
    
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
        
    protected FinancialStatementReportViewHandler(FinancialStatementReportView view) {
        this.view = view;
        fiscalPeriodService =
            LimaServiceFactory.getInstance().getService(
                    FiscalPeriodServiceMonitorable.class);
    }
    
    public void refresh(){
        model = view.getModelTable();
        model.refresh();  
    }
    
    public FinancialStatementReportView getView() {
        return view;
    }
    
    public void createDocument() {
        
        model = view.getModelTable();
        Date selectedBeginDate = model.getBeginDate();
        Date selectedEndDate = model.getEndDate();
        
        if ((selectedBeginDate != null) && (selectedEndDate != null)) {
            //looks for all blocked fiscal periods
            List<FiscalPeriod> blockedFiscalPeriods = new ArrayList<FiscalPeriod>();
            try {
                blockedFiscalPeriods = fiscalPeriodService.getAllBlockedFiscalPeriods();
            } catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug("Enable to create document ", eee);
                }
                ErrorHelper.showErrorDialog("Enable to create document ", eee);
            }
        
            //tells if the fiscaPeriod as been found and is blocked
            boolean error = true;
        
            for (FiscalPeriod blockedFiscalPeriod : blockedFiscalPeriods) {
                if (blockedFiscalPeriod.getBeginDate().equals(selectedBeginDate)
                        && blockedFiscalPeriod.getEndDate().equals(selectedEndDate)
                        && blockedFiscalPeriod.getLocked()) {
                    error = false;
                }
            }
        
            //shows error message to user if the fiscalPeriod is unblocked
            if (error) {
                JOptionPane.showMessageDialog(
                        view,
                        "Can't create document on an open fiscal year",
                        _("lima.common.error"),
                        JOptionPane.ERROR_MESSAGE);
            } else {
                FormatsEnum selectedEnum =
                    (FormatsEnum) view.getDocumentEditor().getSelectedItem();
                model.createDocument(selectedEnum);
            }
        }
    }
}
