/*
 * #%L
 * Lima Swing
 * 
 * $Id: ImportExportEnum.java 3241 2011-08-02 11:39:02Z vsalaun $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5/lima-swing/src/main/java/org/chorem/lima/enums/ImportExportEnum.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.enums;


/**
 * Boolean importMode define if it's a import (true) or an export (false)
 *
 */
public enum ImportExportEnum {
    CSV_ALL_EXPORT(false, true), CSV_ALL_IMPORT(true, true),
    CSV_ACCOUNTCHARTS_EXPORT(false, true), CSV_ACCOUNTCHARTS_IMPORT(true, true),
    CSV_ENTRYBOOKS_EXPORT(false, true), CSV_ENTRYBOOKS_IMPORT(true, true),
    CSV_FINANCIALSTATEMENTS_EXPORT(false, true), CSV_FINANCIALSTATEMENTS_IMPORT(true, true),
    CSV_VAT_EXPORT(false, true), CSV_VAT_IMPORT(true, true),
    PDF_VAT_EXPORT(false, true), PDF_VAT_IMPORT(true, true),
    EBP_ACCOUNTCHARTS_EXPORT(false, false), EBP_ENTRIES_EXPORT(false, false),
    EBP_ACCOUNTCHARTS_IMPORT(true, false), EBP_ENTRIES_IMPORT(true, false);
    
    private final Boolean importMode;
    private final Boolean encodingOption;
    
    /**
     * import mode :
     * true if import, false if export
     */
    private ImportExportEnum(Boolean importMode, Boolean encodingOption) {
        this.importMode = importMode;
        this.encodingOption = encodingOption;
    }
    
    /**
     * encoding choice
     * true if import or export methode let encoding option
     */
    public Boolean getEncodingOption(){
        return this.encodingOption;
    }
    
    public Boolean getImportMode() {
        return this.importMode;
    }
}
