/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.awt.Color;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.AccountServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class AccountsPane
extends JEditorPane
implements HyperlinkListener,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AccountsPane.class);
    protected HomeView view;
    protected AccountServiceMonitorable accountService;
    private static Color redBackground = new Color(255, 238, 238);
    private static Color greenBackground = new Color(238, 255, 238);

    public AccountsPane(HomeView view) {
        this.view = view;
        this.accountService = LimaServiceFactory.getInstance().getService(AccountServiceMonitorable.class);
        this.accountService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.setOpaque(true);
        this.setContentType("text/html");
        this.setEditable(false);
        this.setUI(new BasicEditorPaneUI());
        this.addHyperlinkListener(this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getDescription().equals("#accountschart")) {
            MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
            ui.getHandler().showAccountView((JAXXContext)ui);
        }
    }

    public void refresh() {
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        try {
            List accounts = this.accountService.getAllAccounts();
            if (accounts.size() > 0) {
                this.setBackground(greenBackground);
                String accountsString = I18n._((String)"lima.home.chartaccounts.state1_2", (Object[])new Object[0]) + " " + accounts.size() + " " + I18n._((String)"lima.home.chartaccounts.state2_2", (Object[])new Object[0]) + "<br/><br/><a href='#accountschart'>" + I18n._((String)"lima.home.chartaccounts.modify", (Object[])new Object[0]) + "</a>";
                this.setText(htmlBegin + accountsString + htmlEnd);
            } else {
                this.setBackground(redBackground);
                String accountsString = I18n._((String)"lima.home.chartaccounts.nothing", (Object[])new Object[0]) + "<br/><br/><a href='#accountschart'>" + I18n._((String)"lima.home.chartaccounts.create", (Object[])new Object[0]) + "</a>";
                this.setText(htmlBegin + accountsString + htmlEnd);
            }
        }
        catch (LimaException eee) {
            log.debug((Object)"Can't get datas account editor pane home", (Throwable)eee);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("Account") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

