/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybooksreports;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.celleditor.BigDecimalTableCellRenderer;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsTableModel;
import org.chorem.lima.ui.entrybooksreports.EntryBooksReportsViewHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class EntryBooksReportsTable
extends JXTable
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected EntryBooksReportsViewHandler handler;
    protected EntryBooksReportsTableModel model;
    private Highlighter colorReportsDatas;
    private FinancialTransaction oldRow;
    private Boolean highlighterReportsDatasBoolean;

    public EntryBooksReportsTable(EntryBooksReportsViewHandler handler, EntryBooksReportsTableModel model) {
        this.handler = handler;
        this.model = model;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.highlighterReportsDatasBoolean = true;
        this.setDefaultRenderer(BigDecimal.class, new BigDecimalTableCellRenderer());
        this.addColorReportsDatas();
    }

    protected void addColorReportsDatas() {
        if (this.colorReportsDatas != null) {
            this.removeHighlighter(this.colorReportsDatas);
        }
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Entry entry = EntryBooksReportsTable.this.model.getElementAt(adapter.row);
                FinancialTransaction financialTransaction = entry.getFinancialTransaction();
                if (financialTransaction != EntryBooksReportsTable.this.oldRow) {
                    EntryBooksReportsTable.this.highlighterReportsDatasBoolean = EntryBooksReportsTable.this.highlighterReportsDatasBoolean == false;
                }
                EntryBooksReportsTable.this.oldRow = financialTransaction;
                if (adapter.row == 0) {
                    EntryBooksReportsTable.this.highlighterReportsDatasBoolean = false;
                }
                return EntryBooksReportsTable.this.highlighterReportsDatasBoolean;
            }
        };
        this.colorReportsDatas = new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        this.addHighlighter(this.colorReportsDatas);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && !this.isEditing()) {
            this.clearSelection();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

